"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var axis_utils_1 = require("../lib/axes/axis_utils");
var specs_1 = require("../lib/series/specs");
var utils_1 = require("./utils");
exports.DEFAULT_LINE_OVERFLOW = 0;
function computeYDomainLineAnnotationDimensions(dataValues, yScale, chartRotation, lineOverflow, axisPosition, chartDimensions, lineColor, marker, markerDimensions) {
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var isHorizontalChartRotation = utils_1.isHorizontalRotation(chartRotation);
    var markerOffsets = markerDimensions || { width: 0, height: 0 };
    var lineProps = [];
    dataValues.forEach(function (datum) {
        var dataValue = datum.dataValue;
        var details = {
            detailsText: datum.details,
            headerText: datum.header || dataValue.toString(),
        };
        // d3.scale will return 0 for '', rendering the line incorrectly at 0
        if (dataValue === '') {
            return;
        }
        var scaledYValue = yScale.scale(dataValue);
        if (isNaN(scaledYValue)) {
            return;
        }
        var _a = __read(yScale.domain, 2), domainStart = _a[0], domainEnd = _a[1];
        if (domainStart > dataValue || domainEnd < dataValue) {
            return;
        }
        var yDomainPosition = scaledYValue;
        var leftHorizontalAxis = [0 - lineOverflow, yDomainPosition, chartWidth, yDomainPosition];
        var rightHorizontaAxis = [0, yDomainPosition, chartWidth + lineOverflow, yDomainPosition];
        // Without overflow applied
        var baseLinePosition = isHorizontalChartRotation
            ? [0, yDomainPosition, chartWidth, yDomainPosition]
            : [yDomainPosition, 0, yDomainPosition, chartHeight];
        var linePosition = isHorizontalChartRotation
            ? axisPosition === specs_1.Position.Left
                ? leftHorizontalAxis
                : rightHorizontaAxis
            : [0, yDomainPosition, chartHeight + lineOverflow, yDomainPosition];
        var markerPosition = isHorizontalChartRotation
            ? __spread(linePosition)
            : [yDomainPosition, 0, yDomainPosition, chartHeight + lineOverflow];
        if (isHorizontalChartRotation) {
            if (axisPosition === specs_1.Position.Left) {
                markerPosition[0] -= markerOffsets.width;
            }
            else {
                markerPosition[2] += markerOffsets.width;
            }
            if (chartRotation === 180) {
                markerPosition[1] = chartHeight - markerPosition[1];
                markerPosition[3] = chartHeight - markerPosition[3];
            }
        }
        else {
            markerPosition[3] += markerOffsets.height;
            if (chartRotation === 90) {
                markerPosition[0] = chartWidth - markerPosition[0];
                markerPosition[2] = chartWidth - markerPosition[2];
            }
        }
        var markerTransform = getAnnotationLineTooltipTransform(chartRotation, markerPosition, axisPosition);
        var annotationMarker = marker
            ? { icon: marker, transform: markerTransform, color: lineColor, dimensions: markerOffsets }
            : undefined;
        var lineProp = {
            position: linePosition,
            details: details,
            marker: annotationMarker,
            tooltipLinePosition: baseLinePosition,
        };
        lineProps.push(lineProp);
    });
    return lineProps;
}
exports.computeYDomainLineAnnotationDimensions = computeYDomainLineAnnotationDimensions;
function computeXDomainLineAnnotationDimensions(dataValues, xScale, chartRotation, lineOverflow, axisPosition, chartDimensions, lineColor, xScaleOffset, enableHistogramMode, marker, markerDimensions) {
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var markerOffsets = markerDimensions || { width: 0, height: 0 };
    var lineProps = [];
    var alignWithTick = xScale.bandwidth > 0 && !enableHistogramMode;
    dataValues.forEach(function (datum) {
        var dataValue = datum.dataValue;
        var details = {
            detailsText: datum.details,
            headerText: datum.header || dataValue.toString(),
        };
        var offset = xScale.bandwidth / 2 - xScaleOffset;
        var scaledXValue = scaleAndValidateDatum(dataValue, xScale, alignWithTick);
        if (scaledXValue == null) {
            return;
        }
        var xDomainPosition = scaledXValue + offset;
        var linePosition = [0, 0, 0, 0];
        var tooltipLinePosition = [0, 0, 0, 0];
        var markerPosition = [0, 0, 0, 0];
        switch (chartRotation) {
            case 0: {
                var startY = axisPosition === specs_1.Position.Bottom ? 0 : -lineOverflow;
                var endY = axisPosition === specs_1.Position.Bottom ? chartHeight + lineOverflow : chartHeight;
                linePosition = [xDomainPosition, startY, xDomainPosition, endY];
                tooltipLinePosition = [xDomainPosition, 0, xDomainPosition, chartHeight];
                var startMarkerY = axisPosition === specs_1.Position.Bottom ? 0 : -lineOverflow - markerOffsets.height;
                var endMarkerY = axisPosition === specs_1.Position.Bottom ? chartHeight + lineOverflow + markerOffsets.height : chartHeight;
                markerPosition = [xDomainPosition, startMarkerY, xDomainPosition, endMarkerY];
                break;
            }
            case 90: {
                linePosition = [xDomainPosition, -lineOverflow, xDomainPosition, chartWidth];
                tooltipLinePosition = [0, xDomainPosition, chartWidth, xDomainPosition];
                var markerStartX = -lineOverflow - markerOffsets.width;
                markerPosition = [markerStartX, xDomainPosition, chartWidth, xDomainPosition];
                break;
            }
            case -90: {
                linePosition = [xDomainPosition, -lineOverflow, xDomainPosition, chartWidth];
                tooltipLinePosition = [0, chartHeight - xDomainPosition, chartWidth, chartHeight - xDomainPosition];
                var markerStartX = -lineOverflow - markerOffsets.width;
                markerPosition = [markerStartX, chartHeight - xDomainPosition, chartWidth, chartHeight - xDomainPosition];
                break;
            }
            case 180: {
                var startY = axisPosition === specs_1.Position.Bottom ? 0 : -lineOverflow;
                var endY = axisPosition === specs_1.Position.Bottom ? chartHeight + lineOverflow : chartHeight;
                linePosition = [xDomainPosition, startY, xDomainPosition, endY];
                tooltipLinePosition = [xDomainPosition, 0, xDomainPosition, chartHeight];
                var startMarkerY = axisPosition === specs_1.Position.Bottom ? 0 : -lineOverflow - markerOffsets.height;
                var endMarkerY = axisPosition === specs_1.Position.Bottom ? chartHeight + lineOverflow + markerOffsets.height : chartHeight;
                markerPosition = [chartWidth - xDomainPosition, startMarkerY, chartWidth - xDomainPosition, endMarkerY];
                break;
            }
        }
        var markerTransform = getAnnotationLineTooltipTransform(chartRotation, markerPosition, axisPosition);
        var annotationMarker = marker
            ? { icon: marker, transform: markerTransform, color: lineColor, dimensions: markerOffsets }
            : undefined;
        var lineProp = { position: linePosition, details: details, marker: annotationMarker, tooltipLinePosition: tooltipLinePosition };
        lineProps.push(lineProp);
    });
    return lineProps;
}
exports.computeXDomainLineAnnotationDimensions = computeXDomainLineAnnotationDimensions;
function computeLineAnnotationDimensions(annotationSpec, chartDimensions, chartRotation, yScales, xScale, axisPosition, xScaleOffset, enableHistogramMode) {
    var domainType = annotationSpec.domainType, dataValues = annotationSpec.dataValues, marker = annotationSpec.marker, markerDimensions = annotationSpec.markerDimensions, hideLines = annotationSpec.hideLines;
    if (hideLines) {
        return null;
    }
    // TODO : make line overflow configurable via prop
    var lineOverflow = exports.DEFAULT_LINE_OVERFLOW;
    // this type is guaranteed as this has been merged with default
    var lineStyle = annotationSpec.style;
    var lineColor = lineStyle.line.stroke;
    if (domainType === specs_1.AnnotationDomainTypes.XDomain) {
        return computeXDomainLineAnnotationDimensions(dataValues, xScale, chartRotation, lineOverflow, axisPosition, chartDimensions, lineColor, xScaleOffset, enableHistogramMode, marker, markerDimensions);
    }
    var groupId = annotationSpec.groupId;
    var yScale = yScales.get(groupId);
    if (!yScale) {
        return null;
    }
    return computeYDomainLineAnnotationDimensions(dataValues, yScale, chartRotation, lineOverflow, axisPosition, chartDimensions, lineColor, marker, markerDimensions);
}
exports.computeLineAnnotationDimensions = computeLineAnnotationDimensions;
/**
 * Used when we need to snap values to the nearest tick edge, this performs a binary search for the nearest tick
 * @param dataValue - dataValue defined as an annotation cooordinate
 * @param ticks - ticks from the scale
 * @param minInterval - minInterva from the scale
 */
function getNearestTick(dataValue, ticks, minInterval) {
    if (ticks.length === 0) {
        return;
    }
    if (ticks.length === 1) {
        if (Math.abs(dataValue - ticks[0]) <= minInterval / 2) {
            return ticks[0];
        }
        return;
    }
    var numTicks = ticks.length - 1;
    var midIdx = Math.ceil(numTicks / 2);
    var midPoint = ticks[midIdx];
    if (Math.abs(dataValue - midPoint) <= minInterval / 2) {
        return midPoint;
    }
    if (dataValue > midPoint) {
        return getNearestTick(dataValue, ticks.slice(midIdx, ticks.length), minInterval);
    }
    return getNearestTick(dataValue, ticks.slice(0, midIdx), minInterval);
}
exports.getNearestTick = getNearestTick;
function scaleAndValidateDatum(dataValue, scale, alignWithTick) {
    var isContinuous = scale.type !== "ordinal" /* Ordinal */;
    var value = isContinuous && alignWithTick ? getNearestTick(dataValue, scale.ticks(), scale.minInterval) : dataValue;
    var scaledValue = scale.scale(value);
    // d3.scale will return 0 for '', rendering the line incorrectly at 0
    if (isNaN(scaledValue) || (isContinuous && dataValue === '')) {
        return null;
    }
    if (isContinuous) {
        var _a = __read(scale.domain, 2), domainStart = _a[0], domainEnd = _a[1];
        // if we're not aligning the ticks, we need to extend the domain by one more tick for histograms
        var domainEndOffset = alignWithTick ? 0 : scale.minInterval;
        if (domainStart > dataValue || domainEnd + domainEndOffset < dataValue) {
            return null;
        }
    }
    return scaledValue;
}
exports.scaleAndValidateDatum = scaleAndValidateDatum;
function computeRectAnnotationDimensions(annotationSpec, yScales, xScale, enableHistogramMode, barsPadding) {
    var dataValues = annotationSpec.dataValues;
    var groupId = annotationSpec.groupId;
    var yScale = yScales.get(groupId);
    if (!yScale) {
        return null;
    }
    var xDomain = xScale.domain;
    var yDomain = yScale.domain;
    var lastX = xDomain[xDomain.length - 1];
    var xMinInterval = xScale.minInterval;
    var rectsProps = [];
    dataValues.forEach(function (dataValue) {
        var _a = dataValue.coordinates, x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        // if everything is null, return; otherwise we coerce the other coordinates
        if (x0 == null && x1 == null && y0 == null && y1 == null) {
            return;
        }
        if (x0 == null) {
            // if x1 is defined, we want the rect to draw to the end of the scale
            // if we're in histogram mode, extend domain end by min interval
            x0 = enableHistogramMode ? lastX + xMinInterval : lastX;
        }
        if (x1 == null) {
            // if x0 is defined, we want the rect to draw to the start of the scale
            x1 = xDomain[0];
        }
        if (y0 == null) {
            // if y0 is defined, we want the rect to draw to the end of the scale
            y0 = yDomain[yDomain.length - 1];
        }
        if (y1 == null) {
            // if y1 is defined, we want the rect to draw to the start of the scale
            y1 = yDomain[0];
        }
        var alignWithTick = xScale.bandwidth > 0 && !enableHistogramMode;
        var x0Scaled = scaleAndValidateDatum(x0, xScale, alignWithTick);
        var x1Scaled = scaleAndValidateDatum(x1, xScale, alignWithTick);
        var y0Scaled = scaleAndValidateDatum(y0, yScale, false);
        var y1Scaled = scaleAndValidateDatum(y1, yScale, false);
        // TODO: surface this as a warning
        if ([x0Scaled, x1Scaled, y0Scaled, y1Scaled].includes(null)) {
            return;
        }
        var xOffset = 0;
        if (xScale.bandwidth > 0) {
            var xBand = xScale.bandwidth / (1 - xScale.barsPadding);
            xOffset = enableHistogramMode ? (xBand - xScale.bandwidth) / 2 : barsPadding;
        }
        x0Scaled = x0Scaled - xOffset;
        x1Scaled = x1Scaled - xOffset;
        var minX = Math.min(x0Scaled, x1Scaled);
        var minY = Math.min(y0Scaled, y1Scaled);
        var deltaX = Math.abs(x0Scaled - x1Scaled);
        var deltaY = Math.abs(y0Scaled - y1Scaled);
        var xOrigin = minX;
        var yOrigin = minY;
        var width = deltaX;
        var height = deltaY;
        var rectDimensions = {
            x: xOrigin,
            y: yOrigin,
            width: width,
            height: height,
        };
        rectsProps.push({
            rect: rectDimensions,
            details: dataValue.details,
        });
    });
    return rectsProps;
}
exports.computeRectAnnotationDimensions = computeRectAnnotationDimensions;
function getAnnotationAxis(axesSpecs, groupId, domainType) {
    var _a = utils_1.getAxesSpecForSpecId(axesSpecs, groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
    var isXDomainAnnotation = isXDomain(domainType);
    var annotationAxis = isXDomainAnnotation ? xAxis : yAxis;
    return annotationAxis ? annotationAxis.position : null;
}
exports.getAnnotationAxis = getAnnotationAxis;
function computeClusterOffset(totalBarsInCluster, barsShift, bandwidth) {
    if (totalBarsInCluster > 1) {
        return barsShift - bandwidth / 2;
    }
    return 0;
}
exports.computeClusterOffset = computeClusterOffset;
function computeAnnotationDimensions(annotations, chartDimensions, chartRotation, yScales, xScale, axesSpecs, totalBarsInCluster, enableHistogramMode) {
    var annotationDimensions = new Map();
    var barsShift = (totalBarsInCluster * xScale.bandwidth) / 2;
    var band = xScale.bandwidth / (1 - xScale.barsPadding);
    var halfPadding = (band - xScale.bandwidth) / 2;
    var barsPadding = halfPadding * totalBarsInCluster;
    var clusterOffset = computeClusterOffset(totalBarsInCluster, barsShift, xScale.bandwidth);
    // Annotations should always align with the axis line in histogram mode
    var xScaleOffset = utils_1.computeXScaleOffset(xScale, enableHistogramMode, specs_1.HistogramModeAlignments.Start);
    annotations.forEach(function (annotationSpec, annotationId) {
        if (specs_1.isLineAnnotation(annotationSpec)) {
            var groupId = annotationSpec.groupId, domainType = annotationSpec.domainType;
            var annotationAxisPosition = getAnnotationAxis(axesSpecs, groupId, domainType);
            if (!annotationAxisPosition) {
                return;
            }
            var dimensions = computeLineAnnotationDimensions(annotationSpec, chartDimensions, chartRotation, yScales, xScale, annotationAxisPosition, xScaleOffset - clusterOffset, enableHistogramMode);
            if (dimensions) {
                annotationDimensions.set(annotationId, dimensions);
            }
        }
        else if (specs_1.isRectAnnotation(annotationSpec)) {
            var dimensions = computeRectAnnotationDimensions(annotationSpec, yScales, xScale, enableHistogramMode, barsPadding);
            if (dimensions) {
                annotationDimensions.set(annotationId, dimensions);
            }
        }
    });
    return annotationDimensions;
}
exports.computeAnnotationDimensions = computeAnnotationDimensions;
function isWithinLineBounds(axisPosition, linePosition, rawCursorPosition, offset, chartRotation, chartDimensions, domainType, marker) {
    var _a = __read(linePosition, 4), startX = _a[0], startY = _a[1], endX = _a[2], endY = _a[3];
    var isXDomainAnnotation = isXDomain(domainType);
    var cursorPosition = getRotatedCursor(rawCursorPosition, chartDimensions, chartRotation);
    var isCursorWithinXBounds = false;
    var isCursorWithinYBounds = false;
    var isHorizontalChartRotation = utils_1.isHorizontalRotation(chartRotation);
    var chartWidth = chartDimensions.width;
    var chartHeight = chartDimensions.height;
    if (isXDomainAnnotation) {
        isCursorWithinXBounds = isHorizontalChartRotation
            ? cursorPosition.x >= startX - offset && cursorPosition.x <= endX + offset
            : cursorPosition.x >= chartHeight - startX - offset && cursorPosition.x <= chartHeight - endX + offset;
        isCursorWithinYBounds = isHorizontalChartRotation
            ? cursorPosition.y >= startY && cursorPosition.y <= endY
            : cursorPosition.y >= startY - offset && cursorPosition.y <= endY + offset;
    }
    else {
        isCursorWithinXBounds = isHorizontalChartRotation
            ? cursorPosition.x >= startX && cursorPosition.x <= endX
            : cursorPosition.x >= startX - offset && cursorPosition.x <= endX + offset;
        isCursorWithinYBounds = isHorizontalChartRotation
            ? cursorPosition.y >= startY - offset && cursorPosition.y <= endY + offset
            : cursorPosition.y >= chartWidth - startY - offset && cursorPosition.y <= chartWidth - endY + offset;
    }
    // If it's within cursor bounds, return true (no need to check marker bounds)
    if (isCursorWithinXBounds && isCursorWithinYBounds) {
        return true;
    }
    if (!marker) {
        return false;
    }
    // Check if cursor within marker bounds
    var isCursorWithinMarkerXBounds = false;
    var isCursorWithinMarkerYBounds = false;
    var markerWidth = marker.dimensions.width;
    var markerHeight = marker.dimensions.height;
    var markerWidthOffset = offset + markerWidth / 2;
    var markerHeightOffset = offset + markerHeight / 2;
    if (isXDomainAnnotation) {
        var bottomAxisYBounds = chartRotation === 0
            ? cursorPosition.y <= endY + markerHeight && cursorPosition.y >= endY
            : cursorPosition.y >= startY - markerHeight && cursorPosition.y <= startY;
        var topAxisYBounds = chartRotation === 0
            ? cursorPosition.y >= startY - markerHeight && cursorPosition.y <= startY
            : cursorPosition.y <= endY + markerHeight && cursorPosition.y >= endY;
        isCursorWithinMarkerXBounds = isHorizontalChartRotation
            ? cursorPosition.x <= endX + markerWidthOffset && cursorPosition.x >= startX - markerWidthOffset
            : cursorPosition.x >= startX - markerWidthOffset && cursorPosition.x <= startX + markerWidthOffset;
        isCursorWithinMarkerYBounds = isHorizontalChartRotation
            ? axisPosition === specs_1.Position.Top
                ? topAxisYBounds
                : bottomAxisYBounds
            : cursorPosition.y >= startY - markerHeightOffset && cursorPosition.y <= endY + markerHeightOffset;
    }
    else {
        var leftAxisXBounds = chartRotation === 0
            ? cursorPosition.x >= startX - markerWidth && cursorPosition.x <= startX
            : cursorPosition.x <= endX + markerWidth && cursorPosition.x >= endX;
        var rightAxisXBounds = chartRotation === 0
            ? cursorPosition.x <= endX + markerWidth && cursorPosition.x >= endX
            : cursorPosition.x >= startX - markerWidth && cursorPosition.x <= startX;
        isCursorWithinMarkerXBounds = isHorizontalChartRotation
            ? axisPosition === specs_1.Position.Right
                ? rightAxisXBounds
                : leftAxisXBounds
            : cursorPosition.x <= endX + offset + markerWidth && cursorPosition.x >= startX - offset - markerWidth;
        isCursorWithinMarkerYBounds = isHorizontalChartRotation
            ? cursorPosition.y >= startY - markerHeightOffset && cursorPosition.y <= endY + markerHeightOffset
            : cursorPosition.y >= chartWidth - startY - markerHeightOffset &&
                cursorPosition.y <= chartWidth - endY + markerHeightOffset;
    }
    return isCursorWithinMarkerXBounds && isCursorWithinMarkerYBounds;
}
exports.isWithinLineBounds = isWithinLineBounds;
function isVerticalAnnotationLine(isXDomainAnnotation, isHorizontalChartRotation) {
    if (isXDomainAnnotation) {
        return isHorizontalChartRotation;
    }
    return !isHorizontalChartRotation;
}
exports.isVerticalAnnotationLine = isVerticalAnnotationLine;
function getAnnotationLineTooltipXOffset(chartRotation, axisPosition) {
    var xOffset = 0;
    var isHorizontalAxis = axis_utils_1.isHorizontal(axisPosition);
    var isChartHorizontalRotation = utils_1.isHorizontalRotation(chartRotation);
    if (isHorizontalAxis) {
        xOffset = isChartHorizontalRotation ? 50 : 0;
    }
    else {
        xOffset = isChartHorizontalRotation ? (axisPosition === specs_1.Position.Right ? 100 : 0) : 50;
    }
    return xOffset;
}
exports.getAnnotationLineTooltipXOffset = getAnnotationLineTooltipXOffset;
function getAnnotationLineTooltipYOffset(chartRotation, axisPosition) {
    var yOffset = 0;
    var isHorizontalAxis = axis_utils_1.isHorizontal(axisPosition);
    var isChartHorizontalRotation = utils_1.isHorizontalRotation(chartRotation);
    if (isHorizontalAxis) {
        yOffset = isChartHorizontalRotation ? (axisPosition === specs_1.Position.Top ? 0 : 100) : 50;
    }
    else {
        yOffset = isChartHorizontalRotation ? 50 : 100;
    }
    return yOffset;
}
exports.getAnnotationLineTooltipYOffset = getAnnotationLineTooltipYOffset;
function getAnnotationLineTooltipPosition(chartRotation, linePosition, axisPosition) {
    var _a = __read(linePosition, 4), startX = _a[0], startY = _a[1], endX = _a[2], endY = _a[3];
    var xPosition = axisPosition === specs_1.Position.Right ? endX : startX;
    var yPosition = axisPosition === specs_1.Position.Top ? startY : endY;
    var xOffset = getAnnotationLineTooltipXOffset(chartRotation, axisPosition);
    var yOffset = getAnnotationLineTooltipYOffset(chartRotation, axisPosition);
    return { xPosition: xPosition, yPosition: yPosition, xOffset: xOffset, yOffset: yOffset };
}
exports.getAnnotationLineTooltipPosition = getAnnotationLineTooltipPosition;
function toTransformString(position) {
    var xPosition = position.xPosition, yPosition = position.yPosition, xOffset = position.xOffset, yOffset = position.yOffset;
    var xTranslation = "calc(" + xPosition + "px - " + xOffset + "%)";
    var yTranslation = "calc(" + yPosition + "px - " + yOffset + "%)";
    return "translate(" + xTranslation + "," + yTranslation + ")";
}
exports.toTransformString = toTransformString;
function getAnnotationLineTooltipTransform(chartRotation, linePosition, axisPosition) {
    var position = getAnnotationLineTooltipPosition(chartRotation, linePosition, axisPosition);
    return toTransformString(position);
}
exports.getAnnotationLineTooltipTransform = getAnnotationLineTooltipTransform;
function isXDomain(domainType) {
    return domainType === specs_1.AnnotationDomainTypes.XDomain;
}
exports.isXDomain = isXDomain;
function computeLineAnnotationTooltipState(cursorPosition, annotationLines, groupId, domainType, style, chartRotation, chartDimensions, axesSpecs) {
    var annotationTooltipState = {
        isVisible: false,
        transform: '',
        annotationType: specs_1.AnnotationTypes.Line,
    };
    var _a = utils_1.getAxesSpecForSpecId(axesSpecs, groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
    var isXDomainAnnotation = isXDomain(domainType);
    var annotationAxis = isXDomainAnnotation ? xAxis : yAxis;
    var chartWidth = chartDimensions.width;
    var chartHeight = chartDimensions.height;
    if (!annotationAxis) {
        return annotationTooltipState;
    }
    var axisPosition = annotationAxis.position;
    annotationLines.forEach(function (line) {
        var lineOffset = style.line.strokeWidth / 2;
        var isWithinBounds = isWithinLineBounds(axisPosition, line.position, cursorPosition, lineOffset, chartRotation, chartDimensions, domainType, line.marker);
        if (isWithinBounds) {
            annotationTooltipState.isVisible = true;
            // Position tooltip based on axis position & lineOffset amount
            var _a = __read(line.tooltipLinePosition, 4), tooltipStartX = _a[0], tooltipStartY = _a[1], tooltipEndX = _a[2], tooltipEndY = _a[3];
            var tooltipLinePosition = [tooltipStartX, tooltipStartY, tooltipEndX, tooltipEndY];
            annotationTooltipState.transform = getAnnotationLineTooltipTransform(chartRotation, tooltipLinePosition, axisPosition);
            if (chartRotation === 180 && domainType === specs_1.AnnotationDomainTypes.YDomain) {
                var flippedYDomainTooltipLinePosition = [
                    tooltipStartX,
                    chartHeight - tooltipStartY,
                    tooltipEndX,
                    chartHeight - tooltipEndY,
                ];
                annotationTooltipState.transform = getAnnotationLineTooltipTransform(chartRotation, flippedYDomainTooltipLinePosition, axisPosition);
            }
            if (chartRotation === 180 && domainType === specs_1.AnnotationDomainTypes.XDomain) {
                var rotatedXDomainTooltipLinePosition = [
                    chartWidth - tooltipStartX,
                    tooltipStartY,
                    chartWidth - tooltipEndX,
                    tooltipEndY,
                ];
                annotationTooltipState.transform = getAnnotationLineTooltipTransform(chartRotation, rotatedXDomainTooltipLinePosition, axisPosition);
            }
            if (chartRotation === 90 && domainType === specs_1.AnnotationDomainTypes.YDomain) {
                var rotatedYDomainTooltipLinePosition = [
                    chartWidth - tooltipStartX,
                    tooltipStartY,
                    chartWidth - tooltipEndX,
                    tooltipEndY,
                ];
                annotationTooltipState.transform = getAnnotationLineTooltipTransform(chartRotation, rotatedYDomainTooltipLinePosition, axisPosition);
            }
            if (line.details) {
                annotationTooltipState.header = line.details.headerText;
                annotationTooltipState.details = line.details.detailsText;
            }
        }
    });
    return annotationTooltipState;
}
exports.computeLineAnnotationTooltipState = computeLineAnnotationTooltipState;
function isWithinRectBounds(cursorPosition, _a) {
    var startX = _a.startX, endX = _a.endX, startY = _a.startY, endY = _a.endY;
    var withinXBounds = cursorPosition.x > startX && cursorPosition.x < endX;
    var withinYBounds = cursorPosition.y > startY && cursorPosition.y < endY;
    return withinXBounds && withinYBounds;
}
exports.isWithinRectBounds = isWithinRectBounds;
function isRightRectTooltip(chartRotation, cursorPosition, chartWidth) {
    var xPosition = utils_1.isHorizontalRotation(chartRotation) ? cursorPosition.x : cursorPosition.y;
    return chartRotation === -90 ? xPosition > chartWidth / 2 : xPosition < chartWidth / 2;
}
exports.isRightRectTooltip = isRightRectTooltip;
function isBottomRectTooltip(chartRotation, cursorPosition, chartHeight) {
    var yPosition = utils_1.isHorizontalRotation(chartRotation) ? cursorPosition.y : cursorPosition.x;
    return chartRotation === 180 ? yPosition > chartHeight / 2 : yPosition < chartHeight / 2;
}
exports.isBottomRectTooltip = isBottomRectTooltip;
function computeRectTooltipLeft(chartRotation, isRightTooltip, _a, cursorX, chartWidth) {
    var startX = _a.startX, endX = _a.endX;
    var isHorizontalChartRotation = utils_1.isHorizontalRotation(chartRotation);
    var horizontalLeft = isRightTooltip ? endX : startX;
    return isHorizontalChartRotation ? (chartRotation === 180 ? chartWidth - horizontalLeft : horizontalLeft) : cursorX;
}
exports.computeRectTooltipLeft = computeRectTooltipLeft;
function computeRectTooltipTop(chartRotation, isBottomTooltip, _a, cursorY, chartHeight) {
    var startX = _a.startX, endX = _a.endX;
    var isHorizontalChartRotation = utils_1.isHorizontalRotation(chartRotation);
    var verticalTop = isBottomTooltip ? endX : startX;
    return isHorizontalChartRotation ? cursorY : chartRotation === -90 ? chartHeight - verticalTop : verticalTop;
}
exports.computeRectTooltipTop = computeRectTooltipTop;
function computeRectTooltipOffset(isRightTooltip, isBottomTooltip, chartRotation) {
    var offsetLeft = isRightTooltip ? (chartRotation === 180 ? '-100%' : '0') : chartRotation === 180 ? '0' : '-100%';
    var offsetTop = isBottomTooltip ? (chartRotation === -90 ? '-100%' : '0') : chartRotation === -90 ? '0' : '-100%';
    return { offsetLeft: offsetLeft, offsetTop: offsetTop };
}
exports.computeRectTooltipOffset = computeRectTooltipOffset;
function getRotatedCursor(rawCursorPosition, chartDimensions, chartRotation) {
    var x = rawCursorPosition.x, y = rawCursorPosition.y;
    var height = chartDimensions.height, width = chartDimensions.width;
    switch (chartRotation) {
        case 0:
            return { x: x, y: y };
        case 90:
            return { x: y, y: x };
        case -90:
            return { x: height - y, y: width - x };
        case 180:
            return { x: width - x, y: height - y };
    }
}
exports.getRotatedCursor = getRotatedCursor;
function computeRectAnnotationTooltipState(rawCursorPosition, annotationRects, chartRotation, chartDimensions, renderTooltip) {
    var cursorPosition = getRotatedCursor(rawCursorPosition, chartDimensions, chartRotation);
    var annotationTooltipState = {
        isVisible: false,
        transform: '',
        annotationType: specs_1.AnnotationTypes.Rectangle,
    };
    var isRightTooltip = isRightRectTooltip(chartRotation, cursorPosition, chartDimensions.width);
    var isBottomTooltip = isBottomRectTooltip(chartRotation, cursorPosition, chartDimensions.height);
    annotationRects.forEach(function (rectProps) {
        var rect = rectProps.rect, details = rectProps.details;
        var startX = rect.x;
        var endX = startX + rect.width;
        var startY = rect.y;
        var endY = startY + rect.height;
        var isWithinBounds = isWithinRectBounds(cursorPosition, { startX: startX, endX: endX, startY: startY, endY: endY });
        if (isWithinBounds) {
            annotationTooltipState.isVisible = true;
            annotationTooltipState.details = details;
            var tooltipLeft = computeRectTooltipLeft(chartRotation, isRightTooltip, { startX: startX, endX: endX }, rawCursorPosition.x, chartDimensions.width);
            var tooltipTop = computeRectTooltipTop(chartRotation, isBottomTooltip, { startX: startX, endX: endX }, rawCursorPosition.y, chartDimensions.height);
            var _a = computeRectTooltipOffset(isRightTooltip, isBottomTooltip, chartRotation), offsetLeft = _a.offsetLeft, offsetTop = _a.offsetTop;
            annotationTooltipState.top = tooltipTop;
            annotationTooltipState.left = tooltipLeft;
            annotationTooltipState.transform = "translate(" + offsetLeft + ", " + offsetTop + ")";
            annotationTooltipState.renderTooltip = renderTooltip;
        }
    });
    return annotationTooltipState;
}
exports.computeRectAnnotationTooltipState = computeRectAnnotationTooltipState;
function computeAnnotationTooltipState(cursorPosition, annotationDimensions, annotationSpecs, chartRotation, axesSpecs, chartDimensions) {
    var e_1, _a;
    try {
        for (var annotationDimensions_1 = __values(annotationDimensions), annotationDimensions_1_1 = annotationDimensions_1.next(); !annotationDimensions_1_1.done; annotationDimensions_1_1 = annotationDimensions_1.next()) {
            var _b = __read(annotationDimensions_1_1.value, 2), annotationId = _b[0], annotationDimension = _b[1];
            var spec = annotationSpecs.get(annotationId);
            if (!spec) {
                continue;
            }
            var groupId = spec.groupId;
            if (specs_1.isLineAnnotation(spec)) {
                if (spec.hideTooltips || spec.hideLines) {
                    continue;
                }
                var lineAnnotationTooltipState = computeLineAnnotationTooltipState(cursorPosition, annotationDimension, groupId, spec.domainType, spec.style, // this type is guaranteed as this has been merged with default
                chartRotation, chartDimensions, axesSpecs);
                if (lineAnnotationTooltipState.isVisible) {
                    return lineAnnotationTooltipState;
                }
            }
            else if (specs_1.isRectAnnotation(spec)) {
                var rectAnnotationTooltipState = computeRectAnnotationTooltipState(cursorPosition, annotationDimension, chartRotation, chartDimensions, spec.renderTooltip);
                if (rectAnnotationTooltipState.isVisible) {
                    return rectAnnotationTooltipState;
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (annotationDimensions_1_1 && !annotationDimensions_1_1.done && (_a = annotationDimensions_1.return)) _a.call(annotationDimensions_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return null;
}
exports.computeAnnotationTooltipState = computeAnnotationTooltipState;
//# sourceMappingURL=annotation_utils.js.map