"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
function identity(value) {
    return value;
}
exports.identity = identity;
function compareByValueAsc(firstEl, secondEl) {
    return firstEl - secondEl;
}
exports.compareByValueAsc = compareByValueAsc;
function clamp(value, min, max) {
    return Math.min(Math.max(value, min), max);
}
exports.clamp = clamp;
/**
 * Merges values of a partial structure with a base structure.
 *
 * @param base structure to be duplicated, must have all props of `partial`
 * @param partial structure to override values from base
 *
 * @returns new base structure with updated partial values
 */
function mergePartial(base, partial) {
    if (Array.isArray(base)) {
        return partial ? partial : base; // No nested array merging
    }
    else if (typeof base === 'object') {
        return Object.keys(base).reduce(function (newBase, key) {
            // @ts-ignore
            newBase[key] = mergePartial(base[key], partial && partial[key]);
            return newBase;
        }, __assign({}, base));
    }
    return partial !== undefined ? partial : base;
}
exports.mergePartial = mergePartial;
//# sourceMappingURL=commons.js.map