"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var colors_1 = require("./colors");
var theme_commons_1 = require("./theme_commons");
exports.DARK_THEME = {
    chartPaddings: theme_commons_1.DEFAULT_CHART_PADDING,
    chartMargins: theme_commons_1.DEFAULT_CHART_MARGINS,
    lineSeriesStyle: {
        line: {
            stroke: theme_commons_1.DEFAULT_MISSING_COLOR,
            strokeWidth: 1,
            visible: true,
        },
        border: {
            stroke: 'white',
            strokeWidth: 2,
            visible: false,
        },
        point: {
            visible: true,
            radius: 1,
            stroke: 'white',
            strokeWidth: 0.5,
            opacity: 1,
        },
    },
    areaSeriesStyle: {
        area: {
            fill: theme_commons_1.DEFAULT_MISSING_COLOR,
            visible: true,
            opacity: 1,
        },
        line: {
            stroke: theme_commons_1.DEFAULT_MISSING_COLOR,
            strokeWidth: 1,
            visible: true,
        },
        border: {
            stroke: 'white',
            strokeWidth: 2,
            visible: false,
        },
        point: {
            visible: true,
            radius: 1,
            stroke: 'white',
            strokeWidth: 0.5,
            opacity: 1,
        },
    },
    barSeriesStyle: {
        border: {
            stroke: 'white',
            strokeWidth: 2,
            visible: false,
        },
        displayValue: {
            fontSize: 10,
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            padding: 0,
            fill: 'white',
            offsetX: 0,
            offsetY: 0,
        },
    },
    sharedStyle: theme_commons_1.DEFAULT_GEOMETRY_STYLES,
    scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05,
    },
    axes: {
        axisTitleStyle: {
            fontSize: 12,
            fontStyle: 'bold',
            fontFamily: 'sans-serif',
            padding: 5,
            fill: 'white',
        },
        axisLineStyle: {
            stroke: 'white',
            strokeWidth: 1,
        },
        tickLabelStyle: {
            fontSize: 10,
            fontFamily: 'sans-serif',
            fontStyle: 'normal',
            fill: 'white',
            padding: 0,
        },
        tickLineStyle: {
            stroke: 'white',
            strokeWidth: 1,
        },
    },
    colors: {
        vizColors: colors_1.palettes.echPaletteColorBlind.colors,
        defaultVizColor: theme_commons_1.DEFAULT_MISSING_COLOR,
    },
    legend: {
        verticalWidth: 200,
        horizontalHeight: 64,
    },
    crosshair: {
        band: {
            fill: 'lightgray',
            visible: true,
        },
        line: {
            stroke: 'gray',
            strokeWidth: 1,
            dash: [5, 5],
            visible: true,
        },
    },
};
//# sourceMappingURL=dark_theme.js.map