"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var d3_shape_1 = require("d3-shape");
var CurveType;
(function (CurveType) {
    CurveType[CurveType["CURVE_CARDINAL"] = 0] = "CURVE_CARDINAL";
    CurveType[CurveType["CURVE_NATURAL"] = 1] = "CURVE_NATURAL";
    CurveType[CurveType["CURVE_MONOTONE_X"] = 2] = "CURVE_MONOTONE_X";
    CurveType[CurveType["CURVE_MONOTONE_Y"] = 3] = "CURVE_MONOTONE_Y";
    CurveType[CurveType["CURVE_BASIS"] = 4] = "CURVE_BASIS";
    CurveType[CurveType["CURVE_CATMULL_ROM"] = 5] = "CURVE_CATMULL_ROM";
    CurveType[CurveType["CURVE_STEP"] = 6] = "CURVE_STEP";
    CurveType[CurveType["CURVE_STEP_AFTER"] = 7] = "CURVE_STEP_AFTER";
    CurveType[CurveType["CURVE_STEP_BEFORE"] = 8] = "CURVE_STEP_BEFORE";
    CurveType[CurveType["LINEAR"] = 9] = "LINEAR";
})(CurveType = exports.CurveType || (exports.CurveType = {}));
function getCurveFactory(curveType) {
    if (curveType === void 0) { curveType = 9 /* LINEAR */; }
    switch (curveType) {
        case 0 /* CURVE_CARDINAL */:
            return d3_shape_1.curveCardinal;
        case 1 /* CURVE_NATURAL */:
            return d3_shape_1.curveNatural;
        case 2 /* CURVE_MONOTONE_X */:
            return d3_shape_1.curveMonotoneX;
        case 3 /* CURVE_MONOTONE_Y */:
            return d3_shape_1.curveMonotoneY;
        case 4 /* CURVE_BASIS */:
            return d3_shape_1.curveBasis;
        case 5 /* CURVE_CATMULL_ROM */:
            return d3_shape_1.curveCatmullRom;
        case 6 /* CURVE_STEP */:
            return d3_shape_1.curveStep;
        case 7 /* CURVE_STEP_AFTER */:
            return d3_shape_1.curveStepAfter;
        case 8 /* CURVE_STEP_BEFORE */:
            return d3_shape_1.curveStepBefore;
        case 9 /* LINEAR */:
        default:
            return d3_shape_1.curveLinear;
    }
}
exports.getCurveFactory = getCurveFactory;
//# sourceMappingURL=curves.js.map