"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var BarValues = /** @class */ (function (_super) {
    __extends(BarValues, _super);
    function BarValues() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderBarValues = function () {
            var _a = _this.props, bars = _a.bars, displayValueStyle = _a.displayValueStyle, debug = _a.debug, chartRotation = _a.chartRotation, chartDimensions = _a.chartDimensions;
            return bars.map(function (bar, index) {
                var displayValue = bar.displayValue, x = bar.x, y = bar.y, height = bar.height, width = bar.width;
                if (!displayValue) {
                    return;
                }
                var key = "bar-value-" + index;
                var displayValueProps = rendering_props_utils_1.buildBarValueProps({
                    x: x,
                    y: y,
                    barHeight: height,
                    barWidth: width,
                    displayValueStyle: displayValueStyle,
                    displayValue: displayValue,
                    chartRotation: chartRotation,
                    chartDimensions: chartDimensions,
                });
                var debugProps = __assign({}, displayValueProps, { stroke: 'violet', strokeWidth: 1, fill: 'transparent' });
                return (react_1.default.createElement(react_konva_1.Group, { key: key },
                    debug && react_1.default.createElement(react_konva_1.Rect, __assign({}, debugProps)),
                    displayValue && react_1.default.createElement(react_konva_1.Text, __assign({}, displayValueProps))));
            });
        };
        return _this;
    }
    BarValues.prototype.render = function () {
        var chartDimensions = this.props.chartDimensions;
        return (react_1.default.createElement(react_konva_1.Group, { x: chartDimensions.left, y: chartDimensions.top }, this.renderBarValues()));
    };
    return BarValues;
}(react_1.default.PureComponent));
exports.BarValues = BarValues;
//# sourceMappingURL=bar_values.js.map