"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var icon_1 = require("../icons/icon");
var LegendButtonComponent = /** @class */ (function (_super) {
    __extends(LegendButtonComponent, _super);
    function LegendButtonComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onCollapseLegend = function () {
            _this.props.chartStore.toggleLegendCollapsed();
        };
        return _this;
    }
    LegendButtonComponent.prototype.render = function () {
        var _a = this.props.chartStore, initialized = _a.initialized, legendItems = _a.legendItems, legendCollapsed = _a.legendCollapsed, showLegend = _a.showLegend;
        if (!showLegend.get() || !initialized.get() || legendItems.size === 0) {
            return null;
        }
        var isOpen = !legendCollapsed.get();
        var className = classnames_1.default('echLegendButton', {
            'echLegendButton--isOpen': isOpen,
        });
        return (react_1.default.createElement("button", { type: "button", onClick: this.onCollapseLegend, className: className, "aria-expanded": !legendCollapsed.get(), "aria-label": legendCollapsed.get() ? 'Expand legend' : 'Collapse legend', title: legendCollapsed.get() ? 'Expand legend' : 'Collapse legend', "aria-controls": this.props.legendId },
            react_1.default.createElement(icon_1.Icon, { type: "list" })));
    };
    LegendButtonComponent.displayName = 'Legend';
    return LegendButtonComponent;
}(react_1.default.Component));
exports.LegendButton = mobx_react_1.inject('chartStore')(mobx_react_1.observer(LegendButtonComponent));
//# sourceMappingURL=legend_button.js.map