/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.api.JadxArgs;
import jadx.core.clsp.ClsSet;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.files.InputFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToClsSet {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToClsSet.class);

    public static void usage() {
        LOG.info("<output .jcst or .jar file> <several input dex or jar files> ");
    }

    public static void main(String[] args) throws IOException, DecodeException {
        if (args.length < 2) {
            ConvertToClsSet.usage();
            System.exit(1);
        }
        Path output = Paths.get(args[0], new String[0]);
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>(args.length - 1);
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]);
            if (f.isDirectory()) {
                ConvertToClsSet.addFilesFromDirectory(f, inputFiles);
                continue;
            }
            InputFile.addFilesFrom(f, inputFiles, false);
        }
        for (InputFile inputFile : inputFiles) {
            LOG.info("Loaded: {}", (Object)inputFile.getFile());
        }
        RootNode root = new RootNode(new JadxArgs());
        root.load(inputFiles);
        ClsSet set = new ClsSet();
        set.load(root);
        set.save(output);
        LOG.info("Output: {}", (Object)output);
        LOG.info("done");
    }

    private static void addFilesFromDirectory(File dir, List<InputFile> inputFiles) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ConvertToClsSet.addFilesFromDirectory(file, inputFiles);
                continue;
            }
            try {
                InputFile.addFilesFrom(file, inputFiles, false);
            }
            catch (Exception e) {
                LOG.warn("Skip file: {}, load error: {}", (Object)file, (Object)e.getMessage());
            }
        }
    }
}

