/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.io.ExportControlled;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.mysqla.io.MysqlaSocketConnection;
import com.mysql.cj.x.io.AsyncMessageReader;
import com.mysql.cj.x.io.AsyncMessageWriter;
import com.mysql.cj.x.io.SyncMessageReader;
import com.mysql.cj.x.io.SyncMessageWriter;
import com.mysql.cj.x.io.TlsDecryptingByteChannel;
import com.mysql.cj.x.io.TlsEncryptingByteChannel;
import com.mysql.cj.x.io.XProtocol;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class XProtocolFactory {
    public static XProtocol getInstance(String host, int port, PropertySet propertySet) {
        if (propertySet.getBooleanReadableProperty("xdevapi.useAsyncProtocol").getValue().booleanValue()) {
            return XProtocolFactory.getAsyncInstance(host, port, propertySet);
        }
        MysqlaSocketConnection socketConnection = new MysqlaSocketConnection();
        Properties socketFactoryProperties = new Properties();
        socketConnection.connect(host, port, socketFactoryProperties, propertySet, null, null, 0);
        SyncMessageReader messageReader = new SyncMessageReader(socketConnection.getMysqlInput());
        SyncMessageWriter messageWriter = new SyncMessageWriter(socketConnection.getMysqlOutput());
        return new XProtocol(messageReader, messageWriter, socketConnection.getMysqlSocket(), propertySet);
    }

    public static XProtocol getAsyncInstance(String host, int port, PropertySet propertySet) {
        try {
            boolean sslEnable;
            AsynchronousSocketChannel channel = AsynchronousSocketChannel.open();
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)131072);
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)131072);
            Future<Void> connectPromise = channel.connect(new InetSocketAddress(host, port));
            connectPromise.get();
            AsyncMessageReader messageReader = new AsyncMessageReader(channel);
            messageReader.start();
            AsyncMessageWriter messageWriter = new AsyncMessageWriter(channel);
            XProtocol protocol = new XProtocol(messageReader, messageWriter, channel, propertySet);
            ReadableProperty<Boolean> enableSSLProp = propertySet.getBooleanReadableProperty("xdevapi.ssl-enable");
            ReadableProperty<String> trustStoreUrlProp = propertySet.getStringReadableProperty("xdevapi.ssl-truststore");
            ReadableProperty<Boolean> verifyServerCertProp = propertySet.getBooleanReadableProperty("xdevapi.ssl-verify-server-certificate");
            boolean bl = sslEnable = enableSSLProp.isExplicitlySet() && enableSSLProp.getValue() != false || !enableSSLProp.isExplicitlySet() && (!StringUtils.isNullOrEmpty(trustStoreUrlProp.getValue()) || verifyServerCertProp.getValue() != false);
            if (sslEnable) {
                if (!protocol.hasCapability("tls")) {
                    throw new CJCommunicationsException("Property xdevapi.ssl-enable was set but the server is not configured with SSL.");
                }
                messageReader.stopAfterNextMessage();
                protocol.setCapability("tls", true);
                String trustStoreUrl = trustStoreUrlProp.getValue();
                String trustStoreType = propertySet.getStringReadableProperty("xdevapi.ssl-truststore-type").getValue();
                String trustStorePassword = propertySet.getStringReadableProperty("xdevapi.ssl-truststore-password").getValue();
                boolean verifyServerCert = verifyServerCertProp.isExplicitlySet() && verifyServerCertProp.getValue() != false || !verifyServerCertProp.isExplicitlySet() && !StringUtils.isNullOrEmpty(trustStoreUrl);
                SSLContext sslContext = ExportControlled.getSSLContext(null, null, null, trustStoreUrl, trustStoreType, trustStorePassword, verifyServerCert, null);
                SSLEngine sslEngine = sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                sslEngine.setEnabledProtocols(new String[]{"TLSv1.1", "TLSv1"});
                XProtocolFactory.performTlsHandshake(sslEngine, channel);
                messageReader.setChannel(new TlsDecryptingByteChannel(channel, sslEngine));
                messageWriter.setChannel(new TlsEncryptingByteChannel(channel, sslEngine));
                messageReader.start();
            }
            return protocol;
        }
        catch (IOException | InterruptedException | RuntimeException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }

    private static void performTlsHandshake(SSLEngine sslEngine, AsynchronousSocketChannel channel) throws SSLException {
        sslEngine.beginHandshake();
        ByteBuffer clear = ByteBuffer.allocate(16916);
        ByteBuffer cipher = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            SSLEngineResult res;
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                cipher.clear();
                res = sslEngine.wrap(clear, cipher);
                if (res.getStatus() != SSLEngineResult.Status.OK) {
                    throw new CJCommunicationsException("Unacceptable SSLEngine result: " + res);
                }
                handshakeStatus = sslEngine.getHandshakeStatus();
                cipher.flip();
                XProtocolFactory.write(channel, cipher);
                continue;
            }
            if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) continue;
            cipher.clear();
            XProtocolFactory.read(channel, cipher);
            cipher.flip();
            while (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                res = sslEngine.unwrap(cipher, clear);
                if (res.getStatus() != SSLEngineResult.Status.OK) {
                    throw new CJCommunicationsException("Unacceptable SSLEngine result: " + res);
                }
                handshakeStatus = sslEngine.getHandshakeStatus();
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                sslEngine.getDelegatedTask().run();
                handshakeStatus = sslEngine.getHandshakeStatus();
            }
        }
    }

    private static void write(final AsynchronousSocketChannel channel, final ByteBuffer data) {
        final CompletableFuture f = new CompletableFuture();
        final int bytesToWrite = data.limit();
        CompletionHandler<Integer, Void> handler = new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer bytesWritten, Void nothing) {
                if (bytesWritten < bytesToWrite) {
                    channel.write(data, null, this);
                } else {
                    f.complete(null);
                }
            }

            @Override
            public void failed(Throwable exc, Void nothing) {
                f.completeExceptionally(exc);
            }
        };
        channel.write(data, null, handler);
        try {
            f.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }

    private static void read(AsynchronousSocketChannel channel, ByteBuffer data) {
        Future<Integer> f = channel.read(data);
        try {
            f.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }
}

