/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.query.QuerySearchResult;

public final class QueryFetchSearchResult
extends SearchPhaseResult {
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;

    public QueryFetchSearchResult(StreamInput in) throws IOException {
        super(in);
        this.queryResult = new QuerySearchResult(in);
        this.fetchResult = new FetchSearchResult(in);
    }

    public QueryFetchSearchResult(QuerySearchResult queryResult, FetchSearchResult fetchResult) {
        this.queryResult = queryResult;
        this.fetchResult = fetchResult;
    }

    @Override
    public long getRequestId() {
        return this.queryResult.getRequestId();
    }

    @Override
    public SearchShardTarget getSearchShardTarget() {
        return this.queryResult.getSearchShardTarget();
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.queryResult.setSearchShardTarget(shardTarget);
        this.fetchResult.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int requestIndex) {
        super.setShardIndex(requestIndex);
        this.queryResult.setShardIndex(requestIndex);
        this.fetchResult.setShardIndex(requestIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.queryResult.writeTo(out);
        this.fetchResult.writeTo(out);
    }
}

