/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.internal.ui.filters.FilterDescriptor;
import org.eclipse.dltk.internal.ui.filters.FilterMessages;
import org.eclipse.dltk.internal.ui.filters.NamePatternFilter;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.CustomFiltersDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class CustomFiltersActionGroup
extends ActionGroup {
    private static final String TAG_DUMMY_TO_TEST_EXISTENCE = "TAG_DUMMY_TO_TEST_EXISTENCE";
    private static final String TAG_CUSTOM_FILTERS = "customFilters";
    private static final String TAG_USER_DEFINED_PATTERNS_ENABLED = "userDefinedPatternsEnabled";
    private static final String TAG_USER_DEFINED_PATTERNS = "userDefinedPatterns";
    private static final String TAG_XML_DEFINED_FILTERS = "xmlDefinedFilters";
    private static final String TAG_LRU_FILTERS = "lastRecentlyUsedFilters";
    private static final String TAG_CHILD = "child";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_FILTER_ID = "filterId";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String SEPARATOR = ",";
    private static final int MAX_FILTER_MENU_ENTRIES = 3;
    private static final String RECENT_FILTERS_GROUP_NAME = "recentFiltersGroup";
    private StructuredViewer fViewer;
    private NamePatternFilter fPatternFilter;
    private Map<String, ViewerFilter> fInstalledBuiltInFilters;
    private Map<String, Boolean> fEnabledFilterIds;
    private boolean fUserDefinedPatternsEnabled;
    private String[] fUserDefinedPatterns;
    private FilterDescriptor[] fCachedFilterDescriptors;
    private Stack<String> fLRUFilterIdsStack;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private String[] fFilterIdsUsedInLastViewMenu;
    private HashMap<String, FilterDescriptor> fFilterDescriptorMap;
    private String fTargetId;

    public CustomFiltersActionGroup(IViewPart part, StructuredViewer viewer) {
        this(part.getViewSite().getId(), viewer);
    }

    public CustomFiltersActionGroup(String ownerId, StructuredViewer viewer) {
        this.fTargetId = ownerId;
        this.fViewer = viewer;
        this.fLRUFilterIdsStack = new Stack();
        this.initializeWithPluginContributions();
        this.initializeWithViewDefaults();
        this.installFilters();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public String[] internalGetEnabledFilterIds() {
        HashSet<String> enabledFilterIds = new HashSet<String>(this.fEnabledFilterIds.size());
        for (Map.Entry<String, Boolean> entry : this.fEnabledFilterIds.entrySet()) {
            String id = entry.getKey();
            boolean isEnabled = entry.getValue();
            if (!isEnabled) continue;
            enabledFilterIds.add(id);
        }
        return enabledFilterIds.toArray(new String[enabledFilterIds.size()]);
    }

    public String[] removeFiltersFor(Object parent, Object element, IContentProvider contentProvider) {
        String[] enabledFilters = this.internalGetEnabledFilterIds();
        HashSet<String> newFilters = new HashSet<String>();
        int i = 0;
        while (i < enabledFilters.length) {
            String filterName = enabledFilters[i];
            ViewerFilter filter = this.fInstalledBuiltInFilters.get(filterName);
            if (filter == null) {
                newFilters.add(filterName);
            } else if (this.isSelected(parent, element, contentProvider, filter)) {
                newFilters.add(filterName);
            }
            ++i;
        }
        if (newFilters.size() == enabledFilters.length) {
            return new String[0];
        }
        return newFilters.toArray(new String[newFilters.size()]);
    }

    public void setFilters(String[] newFilters) {
        this.setEnabledFilterIds(newFilters);
        this.updateViewerFilters(true);
    }

    private boolean isSelected(Object parent, Object element, IContentProvider contentProvider, ViewerFilter filter) {
        if (contentProvider instanceof ITreeContentProvider) {
            ITreeContentProvider provider = (ITreeContentProvider)contentProvider;
            while (element != null && !(element instanceof IScriptModel)) {
                if (!filter.select((Viewer)this.fViewer, parent, element)) {
                    return false;
                }
                element = provider.getParent(element);
            }
            return true;
        }
        return filter.select((Viewer)this.fViewer, parent, element);
    }

    private void setFilter(String filterId, boolean state) {
        this.fLRUFilterIdsStack.remove(filterId);
        this.fLRUFilterIdsStack.add(0, filterId);
        this.fEnabledFilterIds.put(filterId, state);
        this.storeViewDefaults();
        this.updateViewerFilters(true);
    }

    private void setEnabledFilterIds(String[] enabledIds) {
        for (String id : this.fEnabledFilterIds.keySet()) {
            this.fEnabledFilterIds.put(id, Boolean.FALSE);
        }
        int i = 0;
        while (i < enabledIds.length) {
            this.fEnabledFilterIds.put(enabledIds[i], Boolean.TRUE);
            ++i;
        }
    }

    private void setUserDefinedPatterns(String[] patterns) {
        this.fUserDefinedPatterns = patterns;
        this.cleanUpPatternDuplicates();
    }

    private void setRecentlyChangedFilters(Stack<FilterDescriptor> changeHistory) {
        Stack<String> oldestFirstStack = new Stack<String>();
        int length = Math.min(changeHistory.size(), 3);
        int i = 0;
        while (i < length) {
            oldestFirstStack.push(changeHistory.pop().getId());
            ++i;
        }
        length = Math.min(this.fLRUFilterIdsStack.size(), 3 - oldestFirstStack.size());
        int NEWEST = 0;
        int i2 = 0;
        while (i2 < length) {
            String filter = (String)this.fLRUFilterIdsStack.remove(NEWEST);
            if (!oldestFirstStack.contains(filter)) {
                oldestFirstStack.push(filter);
            }
            ++i2;
        }
        this.fLRUFilterIdsStack = oldestFirstStack;
    }

    private boolean areUserDefinedPatternsEnabled() {
        return this.fUserDefinedPatternsEnabled;
    }

    private void setUserDefinedPatternsEnabled(boolean state) {
        this.fUserDefinedPatternsEnabled = state;
    }

    private void fillToolBar(IToolBarManager tooBar) {
    }

    public void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator("filters"));
        viewMenu.add((IContributionItem)new GroupMarker(RECENT_FILTERS_GROUP_NAME));
        viewMenu.add((IAction)new ShowFilterDialogAction());
        this.fMenuManager = viewMenu;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CustomFiltersActionGroup.this.removePreviousLRUFilterActions(manager);
                CustomFiltersActionGroup.this.addLRUFilterActions(manager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void removePreviousLRUFilterActions(IMenuManager mm) {
        if (this.fFilterIdsUsedInLastViewMenu == null) {
            return;
        }
        int i = 0;
        while (i < this.fFilterIdsUsedInLastViewMenu.length) {
            mm.remove(this.fFilterIdsUsedInLastViewMenu[i]);
            ++i;
        }
    }

    private void addLRUFilterActions(IMenuManager mm) {
        if (this.fLRUFilterIdsStack.isEmpty()) {
            this.fFilterIdsUsedInLastViewMenu = null;
            return;
        }
        TreeSet<String> sortedFilters = new TreeSet<String>(this.fLRUFilterIdsStack);
        String[] recentlyChangedFilterIds = sortedFilters.toArray(new String[sortedFilters.size()]);
        this.fFilterIdsUsedInLastViewMenu = new String[recentlyChangedFilterIds.length];
        int i = 0;
        while (i < recentlyChangedFilterIds.length) {
            String id;
            this.fFilterIdsUsedInLastViewMenu[i] = id = recentlyChangedFilterIds[i];
            boolean state = this.fEnabledFilterIds.containsKey(id) && this.fEnabledFilterIds.get(id) != false;
            FilterDescriptor filterDesc = this.fFilterDescriptorMap.get(id);
            if (filterDesc != null) {
                FilterActionMenuContributionItem item = new FilterActionMenuContributionItem(this, id, filterDesc.getName(), state, i + 1);
                mm.insertBefore(RECENT_FILTERS_GROUP_NAME, (IContributionItem)item);
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        this.fCachedFilterDescriptors = null;
        if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
            this.fViewer.setFilters(new ViewerFilter[0]);
        }
        super.dispose();
    }

    private void initializeWithPluginContributions() {
        this.fUserDefinedPatterns = new String[0];
        this.fUserDefinedPatternsEnabled = false;
        FilterDescriptor[] filterDescs = this.getCachedFilterDescriptors();
        this.fFilterDescriptorMap = new HashMap(filterDescs.length);
        this.fEnabledFilterIds = new HashMap<String, Boolean>(filterDescs.length);
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            Boolean isEnabled = filterDescs[i].isEnabled();
            this.fEnabledFilterIds.containsKey(id);
            this.fEnabledFilterIds.put(id, isEnabled);
            this.fFilterDescriptorMap.put(id, filterDescs[i]);
            ++i;
        }
    }

    private void installFilters() {
        this.fInstalledBuiltInFilters = new HashMap<String, ViewerFilter>(this.fEnabledFilterIds.size());
        this.fPatternFilter = new NamePatternFilter();
        this.fPatternFilter.setPatterns(this.getUserAndBuiltInPatterns());
        this.fViewer.addFilter((ViewerFilter)this.fPatternFilter);
        this.updateBuiltInFilters();
    }

    private void updateViewerFilters(boolean refresh) {
        String[] patterns = this.getUserAndBuiltInPatterns();
        this.fPatternFilter.setPatterns(patterns);
        this.fViewer.getControl().setRedraw(false);
        this.updateBuiltInFilters();
        if (refresh) {
            this.fViewer.refresh();
        }
        this.fViewer.getControl().setRedraw(true);
    }

    private void updateBuiltInFilters() {
        Set<String> installedFilters = this.fInstalledBuiltInFilters.keySet();
        HashSet<String> filtersToAdd = new HashSet<String>(this.fEnabledFilterIds.size());
        HashSet<String> filtersToRemove = new HashSet<String>(this.fEnabledFilterIds.size());
        for (Map.Entry<String, Boolean> entry : this.fEnabledFilterIds.entrySet()) {
            String id = entry.getKey();
            boolean isEnabled = entry.getValue();
            if (isEnabled && !installedFilters.contains(id)) {
                filtersToAdd.add(id);
                continue;
            }
            if (isEnabled || !installedFilters.contains(id)) continue;
            filtersToRemove.add(id);
        }
        FilterDescriptor[] filterDescs = this.getCachedFilterDescriptors();
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            boolean isCustomFilter = filterDescs[i].isCustomFilter();
            if (isCustomFilter) {
                ViewerFilter filter;
                if (filtersToAdd.contains(id) && (filter = filterDescs[i].createViewerFilter()) != null) {
                    this.fViewer.addFilter(filter);
                    this.fInstalledBuiltInFilters.put(id, filter);
                }
                if (filtersToRemove.contains(id)) {
                    this.fViewer.removeFilter(this.fInstalledBuiltInFilters.get(id));
                    this.fInstalledBuiltInFilters.remove(id);
                }
            }
            ++i;
        }
    }

    private String[] getUserAndBuiltInPatterns() {
        ArrayList<String> patterns = new ArrayList<String>(this.fUserDefinedPatterns.length);
        if (this.areUserDefinedPatternsEnabled()) {
            patterns.addAll(Arrays.asList(this.fUserDefinedPatterns));
        }
        FilterDescriptor[] filterDescs = this.getCachedFilterDescriptors();
        int i = 0;
        while (i < filterDescs.length) {
            String id = filterDescs[i].getId();
            boolean isPatternFilter = filterDescs[i].isPatternFilter();
            Boolean isEnabled = this.fEnabledFilterIds.get(id);
            if (isEnabled != null && isPatternFilter && isEnabled.booleanValue()) {
                patterns.add(filterDescs[i].getPattern());
            }
            ++i;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private void initializeWithViewDefaults() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        if (!store.contains(this.getPreferenceKey(TAG_DUMMY_TO_TEST_EXISTENCE))) {
            return;
        }
        this.fUserDefinedPatternsEnabled = store.getBoolean(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED));
        this.setUserDefinedPatterns(CustomFiltersDialog.convertFromString(store.getString(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS)), SEPARATOR));
        for (Map.Entry<String, Boolean> entry : this.fEnabledFilterIds.entrySet()) {
            String id = entry.getKey();
            store.setDefault(id, entry.getValue().booleanValue());
            Boolean isEnabled = store.getBoolean(id);
            this.fEnabledFilterIds.put(id, isEnabled);
        }
        this.fLRUFilterIdsStack.clear();
        String lruFilterIds = store.getString(TAG_LRU_FILTERS);
        StringTokenizer tokenizer = new StringTokenizer(lruFilterIds, SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!this.fFilterDescriptorMap.containsKey(id) || this.fLRUFilterIdsStack.contains(id)) continue;
            this.fLRUFilterIdsStack.push(id);
        }
    }

    private void storeViewDefaults() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        store.setValue(this.getPreferenceKey(TAG_DUMMY_TO_TEST_EXISTENCE), "storedViewPreferences");
        store.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED), this.fUserDefinedPatternsEnabled);
        store.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS), CustomFiltersDialog.convertToString(this.fUserDefinedPatterns, SEPARATOR));
        Iterator<Map.Entry<String, Boolean>> iter = this.fEnabledFilterIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Boolean> entry = iter.next();
            String id = entry.getKey();
            boolean isEnabled = entry.getValue();
            store.setValue(id, isEnabled);
        }
        StringBuilder buf = new StringBuilder(this.fLRUFilterIdsStack.size() * 20);
        Iterator iterString = this.fLRUFilterIdsStack.iterator();
        while (iter.hasNext()) {
            buf.append((String)iterString.next());
            buf.append(SEPARATOR);
        }
        store.setValue(TAG_LRU_FILTERS, buf.toString());
    }

    private String getPreferenceKey(String tag) {
        return "CustomFiltersActionGroup." + this.fTargetId + '.' + tag;
    }

    public void saveState(IMemento memento) {
        IMemento customFilters = memento.createChild(TAG_CUSTOM_FILTERS);
        customFilters.putString(TAG_USER_DEFINED_PATTERNS_ENABLED, Boolean.toString(this.fUserDefinedPatternsEnabled));
        this.saveUserDefinedPatterns(customFilters);
        this.saveXmlDefinedFilters(customFilters);
        this.saveLRUFilters(customFilters);
    }

    private void saveXmlDefinedFilters(IMemento memento) {
        if (this.fEnabledFilterIds != null && !this.fEnabledFilterIds.isEmpty()) {
            IMemento xmlDefinedFilters = memento.createChild(TAG_XML_DEFINED_FILTERS);
            for (Map.Entry<String, Boolean> entry : this.fEnabledFilterIds.entrySet()) {
                String id = entry.getKey();
                Boolean isEnabled = entry.getValue();
                IMemento child = xmlDefinedFilters.createChild(TAG_CHILD);
                child.putString(TAG_FILTER_ID, id);
                child.putString(TAG_IS_ENABLED, isEnabled.toString());
            }
        }
    }

    private void saveLRUFilters(IMemento memento) {
        if (this.fLRUFilterIdsStack != null && !this.fLRUFilterIdsStack.isEmpty()) {
            IMemento lruFilters = memento.createChild(TAG_LRU_FILTERS);
            for (String id : this.fLRUFilterIdsStack) {
                IMemento child = lruFilters.createChild(TAG_CHILD);
                child.putString(TAG_FILTER_ID, id);
            }
        }
    }

    private void saveUserDefinedPatterns(IMemento memento) {
        if (this.fUserDefinedPatterns != null && this.fUserDefinedPatterns.length > 0) {
            IMemento userDefinedPatterns = memento.createChild(TAG_USER_DEFINED_PATTERNS);
            int i = 0;
            while (i < this.fUserDefinedPatterns.length) {
                IMemento child = userDefinedPatterns.createChild(TAG_CHILD);
                child.putString(TAG_PATTERN, this.fUserDefinedPatterns[i]);
                ++i;
            }
        }
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento customFilters = memento.getChild(TAG_CUSTOM_FILTERS);
        if (customFilters == null) {
            return;
        }
        String userDefinedPatternsEnabled = customFilters.getString(TAG_USER_DEFINED_PATTERNS_ENABLED);
        if (userDefinedPatternsEnabled == null) {
            return;
        }
        this.fUserDefinedPatternsEnabled = Boolean.valueOf(userDefinedPatternsEnabled);
        this.restoreUserDefinedPatterns(customFilters);
        this.restoreXmlDefinedFilters(customFilters);
        this.restoreLRUFilters(customFilters);
        this.updateViewerFilters(false);
    }

    private void restoreUserDefinedPatterns(IMemento memento) {
        IMemento userDefinedPatterns = memento.getChild(TAG_USER_DEFINED_PATTERNS);
        if (userDefinedPatterns != null) {
            IMemento[] children = userDefinedPatterns.getChildren(TAG_CHILD);
            String[] patterns = new String[children.length];
            int i = 0;
            while (i < children.length) {
                patterns[i] = children[i].getString(TAG_PATTERN);
                ++i;
            }
            this.setUserDefinedPatterns(patterns);
        } else {
            this.setUserDefinedPatterns(new String[0]);
        }
    }

    private void restoreXmlDefinedFilters(IMemento memento) {
        IMemento xmlDefinedFilters = memento.getChild(TAG_XML_DEFINED_FILTERS);
        if (xmlDefinedFilters != null) {
            IMemento[] children = xmlDefinedFilters.getChildren(TAG_CHILD);
            int i = 0;
            while (i < children.length) {
                String id = children[i].getString(TAG_FILTER_ID);
                Boolean isEnabled = Boolean.valueOf(children[i].getString(TAG_IS_ENABLED));
                this.fEnabledFilterIds.put(id, isEnabled);
                ++i;
            }
        }
    }

    private void restoreLRUFilters(IMemento memento) {
        IMemento lruFilters = memento.getChild(TAG_LRU_FILTERS);
        this.fLRUFilterIdsStack.clear();
        if (lruFilters != null) {
            IMemento[] children = lruFilters.getChildren(TAG_CHILD);
            int i = 0;
            while (i < children.length) {
                String id = children[i].getString(TAG_FILTER_ID);
                if (this.fFilterDescriptorMap.containsKey(id) && !this.fLRUFilterIdsStack.contains(id)) {
                    this.fLRUFilterIdsStack.push(id);
                }
                ++i;
            }
        }
    }

    private void cleanUpPatternDuplicates() {
        if (!this.areUserDefinedPatternsEnabled()) {
            return;
        }
        ArrayList<String> userDefinedPatterns = new ArrayList<String>(Arrays.asList(this.fUserDefinedPatterns));
        FilterDescriptor[] filters = this.getCachedFilterDescriptors();
        int i = 0;
        while (i < filters.length) {
            String pattern;
            if (filters[i].isPatternFilter() && userDefinedPatterns.contains(pattern = filters[i].getPattern())) {
                this.fEnabledFilterIds.put(filters[i].getId(), Boolean.TRUE);
                boolean hasMore = true;
                while (hasMore) {
                    hasMore = userDefinedPatterns.remove(pattern);
                }
            }
            ++i;
        }
        this.fUserDefinedPatterns = userDefinedPatterns.toArray(new String[userDefinedPatterns.size()]);
        this.setUserDefinedPatternsEnabled(this.fUserDefinedPatternsEnabled && this.fUserDefinedPatterns.length > 0);
    }

    private FilterDescriptor[] getCachedFilterDescriptors() {
        if (this.fCachedFilterDescriptors == null) {
            this.fCachedFilterDescriptors = FilterDescriptor.getFilterDescriptors((String)this.fTargetId);
        }
        return this.fCachedFilterDescriptors;
    }

    private void openDialog() {
        CustomFiltersDialog dialog = new CustomFiltersDialog(this.fViewer.getControl().getShell(), this.fTargetId, this.areUserDefinedPatternsEnabled(), this.fUserDefinedPatterns, this.internalGetEnabledFilterIds());
        if (dialog.open() == 0) {
            this.setEnabledFilterIds(dialog.getEnabledFilterIds());
            this.setUserDefinedPatternsEnabled(dialog.areUserDefinedPatternsEnabled());
            this.setUserDefinedPatterns(dialog.getUserDefinedPatterns());
            this.setRecentlyChangedFilters(dialog.getFilterDescriptorChangeHistory());
            this.storeViewDefaults();
            this.updateViewerFilters(true);
        }
    }

    class FilterActionMenuContributionItem
    extends ContributionItem {
        private int fItemNumber;
        private boolean fState;
        private String fFilterId;
        private String fFilterName;
        private CustomFiltersActionGroup fActionGroup;

        public FilterActionMenuContributionItem(CustomFiltersActionGroup actionGroup, String filterId, String filterName, boolean state, int itemNumber) {
            super(filterId);
            this.fActionGroup = actionGroup;
            this.fFilterId = filterId;
            this.fFilterName = filterName;
            this.fState = state;
            this.fItemNumber = itemNumber;
        }

        public void fill(Menu menu, int index) {
            MenuItem mi = new MenuItem(menu, 32, index);
            mi.setText("&" + this.fItemNumber + " " + this.fFilterName);
            mi.setSelection(this.fState);
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterActionMenuContributionItem.this.fState = !FilterActionMenuContributionItem.this.fState;
                    FilterActionMenuContributionItem.this.fActionGroup.setFilter(FilterActionMenuContributionItem.this.fFilterId, FilterActionMenuContributionItem.this.fState);
                }
            });
        }

        public boolean isDynamic() {
            return true;
        }
    }

    class ShowFilterDialogAction
    extends Action {
        ShowFilterDialogAction() {
            this.setText(FilterMessages.OpenCustomFiltersDialogAction_text);
            this.setImageDescriptor(DLTKPluginImages.DESC_ELCL_FILTER);
            this.setDisabledImageDescriptor(DLTKPluginImages.DESC_DLCL_FILTER);
        }

        public void run() {
            CustomFiltersActionGroup.this.openDialog();
        }
    }
}

