/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.preferences.CSourcePreviewerUpdater;
import org.eclipse.cdt.internal.ui.preferences.CodeTemplateSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private Template fTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    private Button fAutoInsertCheckbox;
    private boolean fIsNameModifiable;
    private boolean fIsContextTypeModifiable;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private final Map<String, TextViewerAction> fGlobalActions = new HashMap<String, TextViewerAction>(10);
    private final List<String> fSelectionActions = new ArrayList<String>(3);
    private String[][] fContextTypes;
    private ContextTypeRegistry fContextTypeRegistry;
    private final TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, boolean isContextTypeModifiable, ContextTypeRegistry registry) {
        super(parent);
        String title = edit ? PreferencesMessages.EditTemplateDialog_title_edit : PreferencesMessages.EditTemplateDialog_title_new;
        this.setTitle(title);
        this.fTemplate = template;
        this.fIsNameModifiable = isNameModifiable;
        this.fIsContextTypeModifiable = isContextTypeModifiable;
        ArrayList<String[]> contexts = new ArrayList<String[]>();
        Iterator it = registry.contextTypes();
        while (it.hasNext()) {
            TemplateContextType type = (TemplateContextType)it.next();
            contexts.add(0, new String[]{type.getId(), type.getName(), ""});
        }
        Collections.sort(contexts, new Comparator<String[]>(){

            @Override
            public int compare(String[] s1, String[] s2) {
                return s1[1].compareTo(s2[1]);
            }
        });
        this.fContextTypes = (String[][])contexts.toArray((T[])new String[contexts.size()][]);
        this.fValidationStatus = new StatusInfo();
        this.fContextTypeRegistry = registry;
        TemplateContextType type = this.fContextTypeRegistry.getContextType(template.getContextTypeId());
        this.fTemplateProcessor.setContextType(type);
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.updateStatusAndButtons();
        this.getButton(0).setEnabled(this.getStatus().isOK());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(parent, PreferencesMessages.EditTemplateDialog_name);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = this.fIsContextTypeModifiable ? 3 : 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.fNameText = this.createText(composite);
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditTemplateDialog.this.fSuppressError) {
                        EditTemplateDialog.this.fSuppressError = false;
                        EditTemplateDialog.this.updateStatusAndButtons();
                    }
                }
            });
            if (this.fIsContextTypeModifiable) {
                EditTemplateDialog.createLabel(composite, PreferencesMessages.EditTemplateDialog_contextType);
                this.fContextCombo = new Combo(composite, 8);
                this.fContextCombo.setVisibleItemCount(10);
                String[][] stringArray = this.fContextTypes;
                int n = this.fContextTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] contextType = stringArray[n2];
                    this.fContextCombo.add(contextType[1]);
                    ++n2;
                }
                this.fContextCombo.addModifyListener(listener);
            }
        }
        EditTemplateDialog.createLabel(parent, PreferencesMessages.EditTemplateDialog_description);
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(parent, descFlags);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(parent, PreferencesMessages.EditTemplateDialog_pattern);
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(parent);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData());
        this.fInsertVariableButton.setText(PreferencesMessages.EditTemplateDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fTemplate.getName());
            this.fNameText.addModifyListener(listener);
            if (this.fContextCombo != null) {
                this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeId()));
            }
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        EditTemplateDialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText) {
            this.fSuppressError = false;
            this.updateStatusAndButtons();
        } else if (w == this.fContextCombo) {
            String contextId = this.getContextId();
            this.fTemplateProcessor.setContextType(this.fContextTypeRegistry.getContextType(contextId));
            this.reconfigurePatternEditor();
            IDocument document = this.fPatternEditor.getDocument();
            String prefix = this.getPrefix();
            document.set(String.valueOf(prefix) + this.getPattern());
            this.fPatternEditor.setVisibleRegion(prefix.length(), document.getLength() - prefix.length());
            this.updateStatusAndButtons();
        }
    }

    private String getContextId() {
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            String name = this.fContextCombo.getText();
            String[][] stringArray = this.fContextTypes;
            int n = this.fContextTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String[] contextType = stringArray[n2];
                if (name.equals(contextType[1])) {
                    return contextType[0];
                }
                ++n2;
            }
        }
        return this.fTemplate.getContextTypeId();
    }

    protected void doSourceChanged(IDocument document) {
        String text = document.get();
        this.fValidationStatus.setOK();
        TemplateContextType contextType = this.fContextTypeRegistry.getContextType(this.getContextId());
        if (contextType != null) {
            try {
                contextType.validate(text);
            }
            catch (TemplateException e) {
                this.fValidationStatus.setError(e.getLocalizedMessage());
            }
        }
        this.updateAction(ITextEditorActionConstants.UNDO);
        this.updateStatusAndButtons();
    }

    private static GridData getButtonGridData() {
        GridData data = new GridData(768);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        text.setLayoutData((Object)gd);
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        String prefix = this.getPrefix();
        Document document = new Document(String.valueOf(prefix) + this.fTemplate.getPattern());
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        tools.setupCDocumentPartitioner((IDocument)document, "___c_partitioning", null);
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CSourceViewer viewer = new CSourceViewer(parent, null, null, false, 2816, store);
        CodeTemplateSourceViewerConfiguration configuration = new CodeTemplateSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(true);
        viewer.setDocument((IDocument)document, prefix.length(), document.getLength() - prefix.length());
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new CSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        int nLines = document.getNumberOfLines();
        if (nLines < 5) {
            nLines = 5;
        } else if (nLines > 12) {
            nLines = 12;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        return viewer;
    }

    private void reconfigurePatternEditor() {
        if (this.fPatternEditor == null) {
            return;
        }
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CodeTemplateSourceViewerConfiguration configuration = new CodeTemplateSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        this.fPatternEditor.unconfigure();
        this.fPatternEditor.configure((SourceViewerConfiguration)configuration);
        this.fPatternEditor.invalidateTextPresentation();
    }

    private String getPrefix() {
        String id = this.getContextId();
        int idx = this.getIndex(id);
        if (idx != -1) {
            return this.fContextTypes[idx][2];
        }
        return "";
    }

    private void initializeActions() {
        final ArrayList<IHandlerActivation> handlerActivations = new ArrayList<IHandlerActivation>(3);
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
            }
        });
        ActiveShellExpression expression = new ActiveShellExpression(this.fPatternEditor.getControl().getShell());
        TextViewerAction action = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        action.setText(PreferencesMessages.EditTemplateDialog_undo);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new ActionHandler((IAction)action), (Expression)expression));
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 2);
        action.setText(PreferencesMessages.EditTemplateDialog_redo);
        this.fGlobalActions.put(ITextEditorActionConstants.REDO, action);
        handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new ActionHandler((IAction)action), (Expression)expression));
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        action.setText(PreferencesMessages.EditTemplateDialog_cut);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        action.setText(PreferencesMessages.EditTemplateDialog_copy);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        action.setText(PreferencesMessages.EditTemplateDialog_paste);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        action.setText(PreferencesMessages.EditTemplateDialog_select_all);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        action.setText(PreferencesMessages.EditTemplateDialog_content_assist);
        this.fGlobalActions.put("ContentAssistProposal", action);
        handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)new ActionHandler((IAction)action), (Expression)expression));
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getIndex(String contextid) {
        if (contextid == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fContextTypes.length) {
            if (contextid.equals(this.fContextTypes[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        String name = this.fNameText == null ? this.fTemplate.getName() : this.fNameText.getText();
        boolean isAutoInsertable = this.fAutoInsertCheckbox != null && this.fAutoInsertCheckbox.getSelection();
        this.fTemplate = new Template(name, this.fDescriptionText.getText(), this.getContextId(), this.getPattern(), isAutoInsertable);
        super.okPressed();
    }

    private void updateStatusAndButtons() {
        boolean isEmpty;
        StatusInfo status = this.fValidationStatus;
        boolean bl = isEmpty = this.fNameText != null && this.fNameText.getText().length() == 0;
        if (!this.fSuppressError && isEmpty) {
            status = new StatusInfo();
            status.setError(PreferencesMessages.EditTemplateDialog_error_noname);
        } else if (this.fNameText != null && !this.isValidTemplateName(this.fNameText.getText())) {
            status = new StatusInfo();
            status.setError(PreferencesMessages.EditTemplateDialog_error_invalidName);
        }
        this.updateStatus(status);
    }

    private boolean isValidTemplateName(String name) {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.cdt.ui.edit_template_dialog_context");
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    private String getPattern() {
        IDocument doc = this.fPatternEditor.getDocument();
        IRegion visible = this.fPatternEditor.getVisibleRegion();
        try {
            return doc.get(visible.getOffset(), doc.getLength() - visible.getOffset());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    protected Point getInitialSize() {
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        Point restoredSize = super.getInitialSize();
        if (defaultSize.x > restoredSize.x) {
            restoredSize.x = defaultSize.x;
        }
        return restoredSize;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private final ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            if (this.fOperationCode == 2) {
                return;
            }
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

