/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerTableColumnManager
extends SQLTableColumnManager<SQLServerTableColumn, SQLServerTableBase>
implements DBEObjectRenamer<SQLServerTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> IdentityModifier = (monitor, column, sql, command) -> {
        if (column.isAutoGenerated()) {
            try {
                SQLServerTableColumn.IdentityInfo identityInfo = column.getIdentityInfo(monitor);
                long incrementValue = identityInfo.getIncrementValue();
                if (incrementValue <= 0L) {
                    incrementValue = 1L;
                }
                sql.append(" IDENTITY(").append(identityInfo.getSeedValue()).append(",").append(incrementValue).append(")");
            }
            catch (DBCException e) {
                log.error((Object)"Error reading identity information", (Throwable)e);
            }
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> CollateModifier = (monitor, column, sql, command) -> {
        String collationName = column.getCollationName();
        if (!CommonUtils.isEmpty((String)collationName)) {
            sql.append(" COLLATE ").append(collationName);
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> SQLServerDefaultModifier = (monitor, column, sql, command) -> {
        if (!column.isPersisted()) {
            this.DefaultModifier.appendModifier(monitor, column, sql, command);
        } else {
            this.DefaultModifier.appendModifier(monitor, column, sql, command);
        }
    };

    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableColumn> getObjectsCache(SQLServerTableColumn object) {
        return ((SQLServerSchema)((SQLServerTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((SQLServerTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(SQLServerTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.IdentityModifier, this.CollateModifier, this.SQLServerDefaultModifier, this.NullNotNullModifier};
    }

    protected SQLServerTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        SQLServerTable table = (SQLServerTable)container;
        DBSDataType columnType = SQLServerTableColumnManager.findBestDataType((DBPDataSource)table.getDataSource(), (String[])new String[]{"varchar"});
        SQLServerTableColumn column = new SQLServerTableColumn(table);
        column.setName(this.getNewColumnName(monitor, context, (DBSEntity)table));
        column.setDataType((SQLServerDataType)columnType);
        column.setTypeName(columnType == null ? "varchar" : columnType.getName());
        column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
        column.setValueType(columnType == null ? 12 : columnType.getTypeID());
        column.setOrdinalPosition(-1);
        return column;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        boolean hasComment;
        SQLServerTableColumn column = (SQLServerTableColumn)command.getObject();
        boolean bl = hasComment = command.getProperty((Object)"description") != null;
        if (!hasComment || command.getProperties().size() > 1) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + ((SQLServerTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ALTER COLUMN " + this.getNestedDeclaration(monitor, (DBSEntity)((SQLServerTableBase)column.getTable()), (DBECommandAbstract)command, options)));
        }
        if (hasComment) {
            boolean isUpdate = SQLServerUtils.isCommentSet(monitor, ((SQLServerTableBase)column.getTable()).getDatabase(), SQLServerObjectClass.OBJECT_OR_COLUMN, ((SQLServerTableBase)column.getTable()).getObjectId(), column.getObjectId());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Add column comment", "EXEC " + SQLServerUtils.getSystemTableName(((SQLServerTableBase)column.getTable()).getDatabase(), isUpdate ? "sp_updateextendedproperty" : "sp_addextendedproperty") + " 'MS_Description', " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((SQLServerTableColumn)command.getObject()).getDescription()) + "," + " 'user', '" + ((SQLServerTableBase)column.getTable()).getSchema().getName() + "'," + " 'table', '" + ((SQLServerTableBase)column.getTable()).getName() + "'," + " 'column', '" + column.getName() + "'"));
        }
    }

    public void renameObject(DBECommandContext commandContext, SQLServerTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        SQLServerTableColumn column = (SQLServerTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "EXEC " + SQLServerUtils.getSystemTableName(((SQLServerTableBase)column.getTable()).getDatabase(), "sp_rename") + " '" + ((SQLServerTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DML) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + "' , '" + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName()) + "', 'COLUMN'"));
    }
}

