/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.objectweb.asm.ClassReader;

public class DriverClassFindJob
implements DBRRunnableWithProgress {
    private static final Log log = Log.getLog(DriverClassFindJob.class);
    public static final String OBJECT_CLASS_NAME = "java/lang/Object";
    public static final String CLASS_FILE_EXT = ".class";
    private List<String> driverClassNames = new ArrayList<String>();
    private final DriverDescriptor driver;
    private final String interfaceName;
    private final boolean isInterface;

    public DriverClassFindJob(DBPDriver driver, String interfaceName, boolean isInterface) {
        this.driver = (DriverDescriptor)driver;
        this.interfaceName = interfaceName.replace(".", "/");
        this.isInterface = isInterface;
    }

    public List<String> getDriverClassNames() {
        return this.driverClassNames;
    }

    public void run(DBRProgressMonitor monitor) {
        this.findDriverClasses(monitor);
    }

    private void findDriverClasses(DBRProgressMonitor monitor) {
        ArrayList<File> libFiles = new ArrayList<File>();
        ArrayList<URL> libURLs = new ArrayList<URL>();
        for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
            File libFile = dBPDriverLibrary.getLocalFile();
            if (libFile != null && libFile.exists() && !libFile.isDirectory() && dBPDriverLibrary.getType() == DBPDriverLibrary.FileType.jar) {
                libFiles.add(libFile);
                try {
                    libURLs.add(libFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    log.debug((Object)e);
                }
                continue;
            }
            Collection<DriverDescriptor.DriverFileInfo> files = this.driver.getLibraryFiles(dBPDriverLibrary);
            if (files == null) continue;
            for (DriverDescriptor.DriverFileInfo file : files) {
                if (file.getFile() == null || !file.getFile().exists()) continue;
                libFiles.add(file.getFile());
            }
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(libURLs.toArray(new URL[libURLs.size()]));
        for (File libFile : libFiles) {
            if (monitor.isCanceled()) break;
            this.findDriverClasses(monitor, uRLClassLoader, libFile);
        }
    }

    private void findDriverClasses(DBRProgressMonitor monitor, ClassLoader findCL, File libFile) {
        try {
            JarFile currentFile = new JarFile(libFile, false);
            monitor.beginTask(libFile.getName(), currentFile.size());
            Enumeration<JarEntry> e = currentFile.entries();
            while (e.hasMoreElements()) {
                if (monitor.isCanceled()) break;
                JarEntry current = e.nextElement();
                String fileName = current.getName();
                if (!fileName.endsWith(CLASS_FILE_EXT) || fileName.contains("$")) continue;
                String className = fileName.replaceAll("/", ".").replace(CLASS_FILE_EXT, "");
                monitor.subTask(className);
                try {
                    if (this.implementsInterface(currentFile, current, 0)) {
                        this.driverClassNames.add(className);
                    }
                }
                catch (Throwable throwable) {}
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean implementsInterface(JarFile currentFile, JarEntry current, int depth) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream classStream = currentFile.getInputStream(current);){
            ClassReader cr = new ClassReader(classStream);
            int access = cr.getAccess();
            if (depth == 0 && ((access & 1) == 0 || (access & 0x400) != 0)) {
                return false;
            }
            String superName = cr.getSuperName();
            if (this.isInterface) {
                JarEntry jarEntry;
                Object[] interfaces = cr.getInterfaces();
                if (ArrayUtils.contains((Object[])interfaces, (Object)this.interfaceName)) {
                    return true;
                }
                if (!CommonUtils.isEmpty((String)superName) && !superName.equals(OBJECT_CLASS_NAME) && (jarEntry = currentFile.getJarEntry(String.valueOf(superName) + CLASS_FILE_EXT)) != null) {
                    return this.implementsInterface(currentFile, jarEntry, depth + 1);
                }
                Object[] objectArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Object intName = objectArray[n2];
                    JarEntry jarEntry2 = currentFile.getJarEntry(String.valueOf(intName) + CLASS_FILE_EXT);
                    if (jarEntry2 != null && this.implementsInterface(currentFile, jarEntry2, depth + 1)) {
                        return true;
                    }
                    ++n2;
                }
            } else if (superName != null) {
                if (this.interfaceName.equals(superName)) {
                    return true;
                }
                JarEntry jarEntry = currentFile.getJarEntry(String.valueOf(superName) + CLASS_FILE_EXT);
                if (jarEntry != null && this.implementsInterface(currentFile, jarEntry, depth + 1)) {
                    return true;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }
}

