Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _getIconServices = require('./get-icon-services');

var _getIconServices2 = _interopRequireDefault(_getIconServices);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

'use babel';

var MRUItemView = (function () {
  function MRUItemView() {
    _classCallCheck(this, MRUItemView);
  }

  _createClass(MRUItemView, [{
    key: 'initialize',
    value: function initialize(listView, item) {
      this.listView = listView;
      this.item = item;

      this.element = document.createElement('li');
      this.element.itemViewData = this;
      this.element.classList.add('two-lines');

      this.itemPath = null;
      if (item.getPath && typeof item.getPath === 'function') {
        this.itemPath = item.getPath();
      }

      var repo = MRUItemView.repositoryForPath(this.itemPath);
      if (repo != null) {
        var statusIconDiv = document.createElement('div');
        var _status = repo.getCachedPathStatus(this.itemPath);
        if (repo.isStatusNew(_status)) {
          statusIconDiv.className = 'status status-added icon icon-diff-added';
          this.element.appendChild(statusIconDiv);
        } else if (repo.isStatusModified(_status)) {
          statusIconDiv.className = 'status status-modified icon icon-diff-modified';
          this.element.appendChild(statusIconDiv);
        }
      }

      this.firstLineDiv = this.element.appendChild(document.createElement('div'));
      this.firstLineDiv.classList.add('primary-line', 'file');
      if (typeof item.getIconName === 'function') {
        if (atom.config.get('tabs.showIcons')) this.firstLineDiv.classList.add('icon', 'icon-' + item.getIconName());
      } else {
        (0, _getIconServices2['default'])().updateMRUIcon(this);
      }
      this.firstLineDiv.setAttribute('data-name', item.getTitle());
      this.firstLineDiv.innerText = item.getTitle();

      if (this.itemPath) {
        this.firstLineDiv.setAttribute('data-path', this.itemPath);
        var secondLineDiv = this.element.appendChild(document.createElement('div'));
        secondLineDiv.classList.add('secondary-line', 'path', 'no-icon');
        secondLineDiv.innerText = this.itemPath;
      }
    }
  }, {
    key: 'select',
    value: function select() {
      this.element.classList.add('selected');
    }
  }, {
    key: 'unselect',
    value: function unselect() {
      this.element.classList.remove('selected');
    }
  }], [{
    key: 'repositoryForPath',
    value: function repositoryForPath(filePath) {
      if (filePath) {
        var projectPaths = atom.project.getPaths();
        for (var i = 0; i < projectPaths.length; i++) {
          if (filePath === projectPaths[i] || filePath.startsWith(projectPaths[i] + _path2['default'].sep)) {
            return atom.project.getRepositories()[i];
          }
        }
      }
      return null;
    }
  }]);

  return MRUItemView;
})();

exports['default'] = MRUItemView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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