"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueCommentView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../github-dotcom-markdown"));

var _helpers = require("../../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueCommentView extends _react["default"].Component {
  render() {
    const comment = this.props.item;
    const author = comment.author || _helpers.GHOST_USER;
    return _react["default"].createElement("div", {
      className: "issue timeline-item"
    }, _react["default"].createElement("div", {
      className: "info-row"
    }, _react["default"].createElement(_octicon["default"], {
      className: "pre-timeline-item-icon",
      icon: "comment"
    }), _react["default"].createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      alt: author.login,
      title: author.login
    }), _react["default"].createElement("span", {
      className: "comment-message-header"
    }, author.login, " commented", ' ', _react["default"].createElement("a", {
      href: comment.url
    }, _react["default"].createElement(_timeago["default"], {
      time: comment.createdAt
    })))), _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: comment.bodyHTML,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

}

exports.BareIssueCommentView = BareIssueCommentView;

_defineProperty(BareIssueCommentView, "propTypes", {
  switchToIssueish: _propTypes["default"].func.isRequired,
  item: _propTypes["default"].shape({
    author: _propTypes["default"].shape({
      avatarUrl: _propTypes["default"].string.isRequired,
      login: _propTypes["default"].string.isRequired
    }),
    bodyHTML: _propTypes["default"].string.isRequired,
    createdAt: _propTypes["default"].string.isRequired,
    url: _propTypes["default"].string.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueCommentView, {
  item: function () {
    const node = require("./__generated__/issueCommentView_item.graphql");

    if (node.hash && node.hash !== "adc36c52f51de14256693ab9e4eb84bb") {
      console.error("The definition of 'issueCommentView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueCommentView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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