"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ErrorView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderDescription", (description, key) => {
      if (this.props.preformatted) {
        return _react["default"].createElement("pre", {
          key: key,
          className: "github-Message-description"
        }, description);
      } else {
        return _react["default"].createElement("p", {
          key: key,
          className: "github-Message-description"
        }, description);
      }
    });
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Message"
    }, _react["default"].createElement("div", {
      className: "github-Message-wrapper"
    }, _react["default"].createElement("h1", {
      className: "github-Message-title"
    }, this.props.title), this.props.descriptions.map(this.renderDescription), _react["default"].createElement("div", {
      className: "github-Message-action"
    }, this.props.retry && _react["default"].createElement("button", {
      className: "github-Message-button btn btn-primary",
      onClick: this.props.retry
    }, "Try Again"), this.props.logout && _react["default"].createElement("button", {
      className: "github-Message-button btn btn-logout",
      onClick: this.props.logout
    }, "Logout"))));
  }

}

exports["default"] = ErrorView;

_defineProperty(ErrorView, "propTypes", {
  title: _propTypes["default"].string,
  descriptions: _propTypes["default"].arrayOf(_propTypes["default"].string),
  preformatted: _propTypes["default"].bool,
  retry: _propTypes["default"].func,
  logout: _propTypes["default"].func
});

_defineProperty(ErrorView, "defaultProps", {
  title: 'Error',
  descriptions: ['An unknown error occurred'],
  preformatted: false
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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