"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCheckSuiteView = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _checkRunView = _interopRequireDefault(require("./check-run-view"));

var _buildStatus = require("../models/build-status");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCheckSuiteView extends _react["default"].Component {
  render() {
    const {
      icon,
      classSuffix
    } = (0, _buildStatus.buildStatusFromCheckResult)(this.props.checkSuite);
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("li", {
      className: "github-PrStatuses-list-item"
    }, _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon,
      className: `github-PrStatuses--${classSuffix}`
    })), this.props.checkSuite.app && _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-context"
    }, _react["default"].createElement("strong", null, this.props.checkSuite.app.name))), this.props.checkRuns.map(run => _react["default"].createElement(_checkRunView["default"], {
      key: run.id,
      checkRun: run,
      switchToIssueish: this.props.switchToIssueish
    })));
  }

}

exports.BareCheckSuiteView = BareCheckSuiteView;

_defineProperty(BareCheckSuiteView, "propTypes", {
  // Relay
  checkSuite: _propTypes["default"].shape({
    app: _propTypes["default"].shape({
      name: _propTypes["default"].string.isRequired
    }),
    status: _propTypes["default"].oneOf(['QUEUED', 'IN_PROGRESS', 'COMPLETED', 'REQUESTED']).isRequired,
    conclusion: _propTypes["default"].oneOf(['ACTION_REQUIRED', 'TIMED_OUT', 'CANCELLED', 'FAILURE', 'SUCCESS', 'NEUTRAL'])
  }).isRequired,
  checkRuns: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  })).isRequired,
  // Actions
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCheckSuiteView, {
  checkSuite: function () {
    const node = require("./__generated__/checkSuiteView_checkSuite.graphql");

    if (node.hash && node.hash !== "ab1475671a1bc4196d67bfa75ad41446") {
      console.error("The definition of 'checkSuiteView_checkSuite' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkSuiteView_checkSuite.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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