"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _electron = require("electron");

var _atom = require("atom");

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _reporterProxy = require("../reporter-proxy");

var _commands = _interopRequireWildcard(require("../atom/commands"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

class ActionableReviewView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onCancel", () => {
      if (this.buffer.getText() === this.props.originalContent.body) {
        this.setState({
          editing: false
        });
      } else {
        const choice = this.props.confirm({
          message: 'Are you sure you want to discard your unsaved changes?',
          buttons: ['OK', 'Cancel']
        });

        if (choice === 0) {
          this.setState({
            editing: false
          });
        }
      }
    });

    _defineProperty(this, "onSubmitUpdate", async () => {
      const text = this.buffer.getText();

      if (text === this.props.originalContent.body || text === '') {
        this.setState({
          editing: false
        });
        return;
      }

      try {
        await this.props.contentUpdater(this.props.originalContent.id, text);
        this.setState({
          editing: false
        });
      } catch (e) {
        this.buffer.setText(text);
      }
    });

    _defineProperty(this, "reportAbuse", (commentUrl, author) => {
      return new Promise((resolve, reject) => {
        const url = 'https://github.com/contact/report-content?report=' + `${encodeURIComponent(author)}&content_url=${encodeURIComponent(commentUrl)}`;

        _electron.shell.openExternal(url, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
            (0, _reporterProxy.addEvent)('report-abuse', {
              "package": 'github',
              component: this.constructor.name
            });
          }
        });
      });
    });

    _defineProperty(this, "openOnGitHub", url => {
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(url, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
            (0, _reporterProxy.addEvent)('open-comment-in-browser', {
              "package": 'github',
              component: this.constructor.name
            });
          }
        });
      });
    });

    _defineProperty(this, "showActionsMenu", (event, content, author) => {
      event.preventDefault();
      const menu = this.props.createMenu();

      if (content.viewerCanUpdate) {
        menu.append(this.props.createMenuItem({
          label: 'Edit',
          click: () => this.setState({
            editing: true
          })
        }));
      }

      menu.append(this.props.createMenuItem({
        label: 'Open on GitHub',
        click: () => this.openOnGitHub(content.url)
      }));
      menu.append(this.props.createMenuItem({
        label: 'Report abuse',
        click: () => this.reportAbuse(content.url, author.login)
      }));
      menu.popup(_electron.remote.getCurrentWindow());
    });

    this.refEditor = new _refHolder["default"]();
    this.refRoot = new _refHolder["default"]();
    this.buffer = new _atom.TextBuffer();
    this.state = {
      editing: false
    };
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.state.editing && !prevState.editing) {
      this.buffer.setText(this.props.originalContent.body);
      this.refEditor.map(e => e.getElement().focus());
    }
  }

  render() {
    return this.state.editing ? this.renderEditor() : this.props.render(this.showActionsMenu);
  }

  renderEditor() {
    const className = (0, _classnames["default"])('github-Review-editable', {
      'github-Review-editable--disabled': this.props.isPosting
    });
    return _react["default"].createElement("div", {
      className: className,
      ref: this.refRoot.setter
    }, this.renderCommands(), _react["default"].createElement(_atomTextEditor["default"], {
      buffer: this.buffer,
      lineNumberGutterVisible: false,
      softWrapped: true,
      autoHeight: true,
      readOnly: this.props.isPosting,
      refModel: this.refEditor
    }), _react["default"].createElement("footer", {
      className: "github-Review-editable-footer"
    }, _react["default"].createElement("button", {
      className: "github-Review-editableCancelButton btn btn-sm",
      title: "Cancel editing comment",
      disabled: this.props.isPosting,
      onClick: this.onCancel
    }, "Cancel"), _react["default"].createElement("button", {
      className: "github-Review-updateCommentButton btn btn-sm btn-primary",
      title: "Update comment",
      disabled: this.props.isPosting,
      onClick: this.onSubmitUpdate
    }, "Update comment")));
  }

  renderCommands() {
    return _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "github:submit-comment",
      callback: this.onSubmitUpdate
    }), _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.onCancel
    }));
  }

}

exports["default"] = ActionableReviewView;

_defineProperty(ActionableReviewView, "propTypes", {
  // Model
  originalContent: _propTypes["default"].object.isRequired,
  isPosting: _propTypes["default"].bool,
  // Atom environment
  commands: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  contentUpdater: _propTypes["default"].func.isRequired,
  createMenu: _propTypes["default"].func,
  createMenuItem: _propTypes["default"].func,
  // Render prop
  render: _propTypes["default"].func.isRequired
});

_defineProperty(ActionableReviewView, "defaultProps", {
  createMenu:
  /* istanbul ignore next */
  () => new Menu(),
  createMenuItem:
  /* istanbul ignore next */
  (...args) => new MenuItem(...args)
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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