"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _moment = _interopRequireDefault(require("moment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/updatePrReviewSummaryMutation.graphql");

  if (node.hash && node.hash !== "ce6fa7b9b5a5709f8cc8001aa7ba8a15") {
    console.error("The definition of 'updatePrReviewSummaryMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/updatePrReviewSummaryMutation.graphql");
};

var _default = (environment, {
  reviewId,
  reviewBody
}) => {
  const variables = {
    input: {
      pullRequestReviewId: reviewId,
      body: reviewBody
    }
  };
  const optimisticResponse = {
    updatePullRequestReview: {
      pullRequestReview: {
        id: reviewId,
        lastEditedAt: (0, _moment["default"])().toISOString(),
        body: reviewBody,
        bodyHTML: (0, _helpers.renderMarkdown)(reviewBody)
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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