Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _stackTrace = require('stack-trace');

var _stackTrace2 = _interopRequireDefault(_stackTrace);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var API_KEY = '7ddca14cb60cbd1cd12d1b252473b076';
var LIB_VERSION = require('../package.json')['version'];
var StackTraceCache = new WeakMap();

var Reporter = (function () {
  function Reporter() {
    var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Reporter);

    this.request = params.request || window.fetch;
    this.alwaysReport = params.hasOwnProperty('alwaysReport') ? params.alwaysReport : false;
    this.reportPreviousErrors = params.hasOwnProperty('reportPreviousErrors') ? params.reportPreviousErrors : true;
    this.resourcePath = this.normalizePath(params.resourcePath || process.resourcesPath);
    this.reportedErrors = [];
    this.reportedAssertionFailures = [];
  }

  _createClass(Reporter, [{
    key: 'buildNotificationJSON',
    value: function buildNotificationJSON(error, params) {
      return {
        apiKey: API_KEY,
        notifier: {
          name: 'Atom',
          version: LIB_VERSION,
          url: 'https://www.atom.io'
        },
        events: [{
          payloadVersion: '2',
          exceptions: [this.buildExceptionJSON(error, params.projectRoot)],
          severity: params.severity,
          user: {
            id: params.userId
          },
          app: {
            version: params.appVersion,
            releaseStage: params.releaseStage
          },
          device: {
            osVersion: params.osVersion
          },
          metaData: error.metadata
        }]
      };
    }
  }, {
    key: 'buildExceptionJSON',
    value: function buildExceptionJSON(error, projectRoot) {
      return {
        errorClass: error.constructor.name,
        message: error.message,
        stacktrace: this.buildStackTraceJSON(error, projectRoot)
      };
    }
  }, {
    key: 'buildStackTraceJSON',
    value: function buildStackTraceJSON(error, projectRoot) {
      var _this = this;

      return this.parseStackTrace(error).map(function (callSite) {
        return {
          file: _this.scrubPath(callSite.getFileName()),
          method: callSite.getMethodName() || callSite.getFunctionName() || 'none',
          lineNumber: callSite.getLineNumber(),
          columnNumber: callSite.getColumnNumber(),
          inProject: !/node_modules/.test(callSite.getFileName())
        };
      });
    }
  }, {
    key: 'normalizePath',
    value: function normalizePath(pathToNormalize) {
      return pathToNormalize.replace('file:///', '') // Sometimes it's a uri
      .replace(/\\/g, '/'); // Unify path separators across Win/macOS/Linux
    }
  }, {
    key: 'scrubPath',
    value: function scrubPath(pathToScrub) {
      var absolutePath = this.normalizePath(pathToScrub);

      if (this.isBundledFile(absolutePath)) {
        return this.normalizePath(_path2['default'].relative(this.resourcePath, absolutePath));
      } else {
        return absolutePath.replace(this.normalizePath(_fsPlus2['default'].getHomeDirectory()), '~') // Remove users home dir
        .replace(/.*(\/packages\/.*)/, '$1'); // Remove everything before app.asar or packages
      }
    }
  }, {
    key: 'getDefaultNotificationParams',
    value: function getDefaultNotificationParams() {
      return {
        userId: atom.config.get('exception-reporting.userId'),
        appVersion: atom.getVersion(),
        releaseStage: this.getReleaseChannel(atom.getVersion()),
        projectRoot: atom.getLoadSettings().resourcePath,
        osVersion: _os2['default'].platform() + '-' + _os2['default'].arch() + '-' + _os2['default'].release()
      };
    }
  }, {
    key: 'getReleaseChannel',
    value: function getReleaseChannel(version) {
      return version.indexOf('beta') > -1 ? 'beta' : version.indexOf('dev') > -1 ? 'dev' : 'stable';
    }
  }, {
    key: 'performRequest',
    value: function performRequest(json) {
      this.request.call(null, 'https://notify.bugsnag.com', {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json' }),
        body: JSON.stringify(json)
      });
    }
  }, {
    key: 'shouldReport',
    value: function shouldReport(error) {
      if (this.alwaysReport) return true; // Used in specs
      if (atom.config.get('core.telemetryConsent') !== 'limited') return false;
      if (atom.inDevMode()) return false;

      var topFrame = this.parseStackTrace(error)[0];
      var fileName = topFrame ? topFrame.getFileName() : null;
      return fileName && (this.isBundledFile(fileName) || this.isTeletypeFile(fileName));
    }
  }, {
    key: 'parseStackTrace',
    value: function parseStackTrace(error) {
      var callSites = StackTraceCache.get(error);
      if (callSites) {
        return callSites;
      } else {
        callSites = _stackTrace2['default'].parse(error);
        StackTraceCache.set(error, callSites);
        return callSites;
      }
    }
  }, {
    key: 'requestPrivateMetadataConsent',
    value: function requestPrivateMetadataConsent(error, message, reportFn) {
      var notification = undefined,
          dismissSubscription = undefined;

      function reportWithoutPrivateMetadata() {
        if (dismissSubscription) {
          dismissSubscription.dispose();
        }
        delete error.privateMetadata;
        delete error.privateMetadataDescription;
        reportFn(error);
        if (notification) {
          notification.dismiss();
        }
      }

      function reportWithPrivateMetadata() {
        if (error.metadata == null) {
          error.metadata = {};
        }
        for (var key in error.privateMetadata) {
          var value = error.privateMetadata[key];
          error.metadata[key] = value;
        }
        reportWithoutPrivateMetadata();
      }

      var name = error.privateMetadataRequestName;
      if (name != null) {
        if (localStorage.getItem('private-metadata-request:' + name)) {
          return reportWithoutPrivateMetadata(error);
        } else {
          localStorage.setItem('private-metadata-request:' + name, true);
        }
      }

      notification = atom.notifications.addInfo(message, {
        detail: error.privateMetadataDescription,
        description: 'Are you willing to submit this information to a private server for debugging purposes?',
        dismissable: true,
        buttons: [{
          text: 'No',
          onDidClick: reportWithoutPrivateMetadata
        }, {
          text: 'Yes, Submit for Debugging',
          onDidClick: reportWithPrivateMetadata
        }]
      });

      dismissSubscription = notification.onDidDismiss(reportWithoutPrivateMetadata);
    }
  }, {
    key: 'addPackageMetadata',
    value: function addPackageMetadata(error) {
      var activePackages = atom.packages.getActivePackages();
      var availablePackagePaths = atom.packages.getPackageDirPaths();
      if (activePackages.length > 0) {
        var userPackages = {};
        var bundledPackages = {};
        for (var pack of atom.packages.getActivePackages()) {
          if (availablePackagePaths.includes(_path2['default'].dirname(pack.path))) {
            userPackages[pack.name] = pack.metadata.version;
          } else {
            bundledPackages[pack.name] = pack.metadata.version;
          }
        }

        if (error.metadata == null) {
          error.metadata = {};
        }
        error.metadata.bundledPackages = bundledPackages;
        error.metadata.userPackages = userPackages;
      }
    }
  }, {
    key: 'addPreviousErrorsMetadata',
    value: function addPreviousErrorsMetadata(error) {
      if (!this.reportPreviousErrors) return;
      if (!error.metadata) error.metadata = {};
      error.metadata.previousErrors = this.reportedErrors.map(function (error) {
        return error.message;
      });
      error.metadata.previousAssertionFailures = this.reportedAssertionFailures.map(function (error) {
        return error.message;
      });
    }
  }, {
    key: 'reportUncaughtException',
    value: function reportUncaughtException(error) {
      var _this2 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, 'The Atom team would like to collect the following information to resolve this error:', function (error) {
          return _this2.reportUncaughtException(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = 'error';
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedErrors.push(error);
    }
  }, {
    key: 'reportFailedAssertion',
    value: function reportFailedAssertion(error) {
      var _this3 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, 'The Atom team would like to collect some information to resolve an unexpected condition:', function (error) {
          return _this3.reportFailedAssertion(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = 'warning';
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedAssertionFailures.push(error);
    }

    // Used in specs
  }, {
    key: 'setRequestFunction',
    value: function setRequestFunction(requestFunction) {
      this.request = requestFunction;
    }
  }, {
    key: 'isBundledFile',
    value: function isBundledFile(fileName) {
      return this.normalizePath(fileName).indexOf(this.resourcePath) === 0;
    }
  }, {
    key: 'isTeletypeFile',
    value: function isTeletypeFile(fileName) {
      var teletypePath = atom.packages.resolvePackagePath('teletype');
      return teletypePath && this.normalizePath(fileName).indexOf(teletypePath) === 0;
    }
  }]);

  return Reporter;
})();

exports['default'] = Reporter;

Reporter.API_KEY = API_KEY;
Reporter.LIB_VERSION = LIB_VERSION;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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