/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractWinViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public final class Windows8ViewTabDisplayerUI
extends AbstractWinViewTabDisplayerUI {
    private static boolean colorsReady = false;
    private static Color unselFillUpperC;
    private static Color unselFillLowerC;
    private static Color selFillC;
    private static Color focusFillUpperC;
    private static Color focusFillLowerC;
    private static Color mouseOverFillUpperC;
    private static Color mouseOverFillLowerC;
    private static Color attentionFillUpperC;
    private static Color attentionFillLowerC;
    private static Map<Integer, String[]> buttonIconPaths;

    private Windows8ViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new Windows8ViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Windows8ViewTabDisplayerUI.initColors();
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        boolean bl4 = this.isMouseOver(n);
        Windows8ViewTabDisplayerUI.paintTabBackground((Graphics2D)graphics, n2, n3 += 2, n4, n5 -= 2, bl, bl2, bl3, bl4);
    }

    @Override
    int getButtonYPadding() {
        return 1;
    }

    static void paintTabBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Windows8ViewTabDisplayerUI.initColors();
        if (bl2 && !bl3) {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n, n2, focusFillUpperC, n, n2 + n4, focusFillLowerC));
        } else if (bl && !bl3) {
            graphics2D.setColor(selFillC);
        } else if (bl4 && !bl3) {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n, n2, mouseOverFillUpperC, n, n2 + n4, mouseOverFillLowerC));
        } else if (bl3) {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n, n2, attentionFillUpperC, n, n2 + n4, attentionFillLowerC));
        } else {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n, n2, unselFillUpperC, n, n2 + n4, unselFillLowerC));
        }
        graphics2D.fillRect(n, n2, n3, n4);
    }

    private static void initColors() {
        if (!colorsReady) {
            selFillC = UIManager.getColor("tab_sel_fill");
            focusFillUpperC = UIManager.getColor("tab_focus_fill_upper");
            focusFillLowerC = UIManager.getColor("tab_focus_fill_lower");
            unselFillUpperC = UIManager.getColor("tab_unsel_fill_upper");
            unselFillLowerC = UIManager.getColor("tab_unsel_fill_lower");
            mouseOverFillUpperC = UIManager.getColor("tab_mouse_over_fill_upper");
            mouseOverFillLowerC = UIManager.getColor("tab_mouse_over_fill_lower");
            attentionFillUpperC = UIManager.getColor("tab_attention_fill_upper");
            attentionFillLowerC = UIManager.getColor("tab_attention_fill_lower");
            colorsReady = true;
        }
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/openide/awt/resources/win8_bigclose_enabled.png", "org/openide/awt/resources/win8_bigclose_pressed.png", stringArray[0], "org/openide/awt/resources/win8_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win8_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/win8_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win8_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win8_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/win8_restore_group_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win8_restore_group_rollover.png"};
            buttonIconPaths.put(11, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win8_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/win8_minimize_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win8_minimize_rollover.png"};
            buttonIconPaths.put(12, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        Windows8ViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        if (null == icon) {
            return super.getButtonIcon(n, n2);
        }
        return icon;
    }
}

