/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.oops.java_lang_Class;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.soql.JSJavaClass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaField;
import sun.jvm.hotspot.utilities.soql.JSJavaFrame;
import sun.jvm.hotspot.utilities.soql.JSJavaHeap;
import sun.jvm.hotspot.utilities.soql.JSJavaInstance;
import sun.jvm.hotspot.utilities.soql.JSJavaInstanceKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaMethod;
import sun.jvm.hotspot.utilities.soql.JSJavaObjArray;
import sun.jvm.hotspot.utilities.soql.JSJavaObjArrayKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.JSJavaString;
import sun.jvm.hotspot.utilities.soql.JSJavaThread;
import sun.jvm.hotspot.utilities.soql.JSJavaTypeArray;
import sun.jvm.hotspot.utilities.soql.JSJavaTypeArrayKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaVM;
import sun.jvm.hotspot.utilities.soql.JSList;
import sun.jvm.hotspot.utilities.soql.JSMap;

public class JSJavaFactoryImpl
implements JSJavaFactory {
    private Map om = new HashMap();
    private Symbol javaLangString;
    private Symbol javaLangThread;
    private Symbol javaLangClass;

    @Override
    public JSJavaObject newJSJavaObject(Oop oop) {
        JSJavaObject res;
        if (oop == null) {
            return null;
        }
        SoftReference sref = (SoftReference)this.om.get(oop);
        JSJavaObject jSJavaObject = res = sref != null ? (JSJavaObject)sref.get() : null;
        if (res == null) {
            if (oop instanceof TypeArray) {
                res = new JSJavaTypeArray((TypeArray)oop, (JSJavaFactory)this);
            } else if (oop instanceof ObjArray) {
                res = new JSJavaObjArray((ObjArray)oop, (JSJavaFactory)this);
            } else if (oop instanceof Instance) {
                res = this.newJavaInstance((Instance)oop);
            } else if (oop instanceof Method) {
                res = new JSJavaMethod((Method)oop, (JSJavaFactory)this);
            }
        }
        if (res != null) {
            this.om.put(oop, new SoftReference<JSJavaObject>(res));
        }
        return res;
    }

    @Override
    public JSJavaKlass newJSJavaKlass(Klass klass) {
        JSJavaKlass res = null;
        if (klass instanceof InstanceKlass) {
            res = new JSJavaInstanceKlass((InstanceKlass)klass, (JSJavaFactory)this);
        } else if (klass instanceof ObjArrayKlass) {
            res = new JSJavaObjArrayKlass((ObjArrayKlass)klass, (JSJavaFactory)this);
        } else if (klass instanceof TypeArrayKlass) {
            res = new JSJavaTypeArrayKlass((TypeArrayKlass)klass, (JSJavaFactory)this);
        }
        if (res != null) {
            this.om.put(klass, new SoftReference<JSJavaInstanceKlass>((JSJavaInstanceKlass)res));
        }
        return res;
    }

    @Override
    public JSJavaField newJSJavaField(Field field) {
        if (field == null) {
            return null;
        }
        return new JSJavaField(field, this);
    }

    @Override
    public JSJavaThread newJSJavaThread(JavaThread jthread) {
        if (jthread == null) {
            return null;
        }
        return new JSJavaThread(jthread, (JSJavaFactory)this);
    }

    @Override
    public JSJavaFrame newJSJavaFrame(JavaVFrame jvf) {
        if (jvf == null) {
            return null;
        }
        return new JSJavaFrame(jvf, this);
    }

    @Override
    public JSList newJSList(List list) {
        if (list == null) {
            return null;
        }
        return new JSList(list, this);
    }

    @Override
    public JSMap newJSMap(Map map) {
        if (map == null) {
            return null;
        }
        return new JSMap(map, this);
    }

    @Override
    public Object newJSJavaWrapper(Object item) {
        if (item == null) {
            return null;
        }
        if (item instanceof Oop) {
            return this.newJSJavaObject((Oop)item);
        }
        if (item instanceof Field) {
            return this.newJSJavaField((Field)item);
        }
        if (item instanceof JavaThread) {
            return this.newJSJavaThread((JavaThread)item);
        }
        if (item instanceof JavaVFrame) {
            return this.newJSJavaFrame((JavaVFrame)item);
        }
        if (item instanceof List) {
            return this.newJSList((List)item);
        }
        if (item instanceof Map) {
            return this.newJSMap((Map)item);
        }
        return item;
    }

    @Override
    public JSJavaHeap newJSJavaHeap() {
        return new JSJavaHeap(this);
    }

    @Override
    public JSJavaVM newJSJavaVM() {
        return new JSJavaVM(this);
    }

    private Symbol javaLangString() {
        if (this.javaLangString == null) {
            this.javaLangString = this.getSymbol("java/lang/String");
        }
        return this.javaLangString;
    }

    private Symbol javaLangThread() {
        if (this.javaLangThread == null) {
            this.javaLangThread = this.getSymbol("java/lang/Thread");
        }
        return this.javaLangThread;
    }

    private Symbol javaLangClass() {
        if (this.javaLangClass == null) {
            this.javaLangClass = this.getSymbol("java/lang/Class");
        }
        return this.javaLangClass;
    }

    private Symbol getSymbol(String str) {
        return VM.getVM().getSymbolTable().probe(str);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSJavaObject newJavaInstance(Instance instance) {
        void var3_10;
        void var3_8;
        Symbol className = instance.getKlass().getName();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(className != null, "Null class name");
        }
        Object var3_3 = null;
        if (className.equals(this.javaLangString())) {
            JSJavaString jSJavaString = new JSJavaString(instance, (JSJavaFactory)this);
        } else if (className.equals(this.javaLangThread())) {
            JSJavaThread jSJavaThread = new JSJavaThread(instance, (JSJavaFactory)this);
        } else if (className.equals(this.javaLangClass())) {
            Klass reflectedType = java_lang_Class.asKlass(instance);
            if (reflectedType == null) return null;
            JSJavaKlass jk = this.newJSJavaKlass(reflectedType);
            if (jk == null) {
                return null;
            }
            JSJavaClass jSJavaClass = new JSJavaClass(instance, jk, this);
        } else {
            for (Klass kls = instance.getKlass().getSuper(); kls != null; kls = kls.getSuper()) {
                className = kls.getName();
                if (!className.equals(this.javaLangThread())) continue;
                JSJavaThread jSJavaThread = new JSJavaThread(instance, (JSJavaFactory)this);
                break;
            }
        }
        if (var3_8 != null) return var3_10;
        JSJavaInstance jSJavaInstance = new JSJavaInstance(instance, (JSJavaFactory)this);
        return var3_10;
    }
}

