"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
const RandomUtil = require("./RandomUtil");
var AccentColorID;
(function (AccentColorID) {
    AccentColorID[AccentColorID["BRIGHT_ORANGE"] = 5] = "BRIGHT_ORANGE";
    AccentColorID[AccentColorID["SOFT_PINK"] = 6] = "SOFT_PINK";
    AccentColorID[AccentColorID["STRONG_BLUE"] = 1] = "STRONG_BLUE";
    AccentColorID[AccentColorID["STRONG_LIME_GREEN"] = 2] = "STRONG_LIME_GREEN";
    AccentColorID[AccentColorID["VIOLET"] = 7] = "VIOLET";
    AccentColorID[AccentColorID["VIVID_RED"] = 4] = "VIVID_RED";
    /** @deprecated */
    AccentColorID[AccentColorID["YELLOW"] = 3] = "YELLOW";
})(AccentColorID = exports.AccentColorID || (exports.AccentColorID = {}));
exports.STRONG_BLUE = {
    color: '#2391d3',
    id: AccentColorID.STRONG_BLUE,
    name: 'StrongBlue',
};
exports.STRONG_LIME_GREEN = {
    color: '#00c800',
    id: AccentColorID.STRONG_LIME_GREEN,
    name: 'StrongLimeGreen',
};
exports.DEPRECATED_YELLOW = {
    color: '#febf02',
    id: AccentColorID.YELLOW,
    name: 'Yellow',
};
exports.VIVID_RED = {
    color: '#fb0807',
    id: AccentColorID.VIVID_RED,
    name: 'VividRed',
};
exports.BRIGHT_ORANGE = {
    color: '#ff8900',
    id: AccentColorID.BRIGHT_ORANGE,
    name: 'BrightOrange',
};
exports.SOFT_PINK = {
    color: '#fe5ebd',
    id: AccentColorID.SOFT_PINK,
    name: 'SoftPink',
};
exports.VIOLET = {
    color: '#9c00fe',
    id: AccentColorID.VIOLET,
    name: 'Violet',
};
exports.ACCENT_COLORS = [
    exports.BRIGHT_ORANGE,
    exports.SOFT_PINK,
    exports.STRONG_BLUE,
    exports.STRONG_LIME_GREEN,
    exports.VIOLET,
    exports.VIVID_RED,
];
exports.getById = (id) => exports.ACCENT_COLORS.find(color => color.id === id);
exports.getRandom = () => RandomUtil.randomArrayElement(exports.ACCENT_COLORS);
/**
 * Use with caution:
 * This only exists to support deprecated color schemes and
 * is only permitted for usage in a read only manner.
 */
exports.DEPRECATED_ACCENT_COLORS = [
    exports.BRIGHT_ORANGE,
    exports.DEPRECATED_YELLOW,
    exports.SOFT_PINK,
    exports.STRONG_BLUE,
    exports.STRONG_LIME_GREEN,
    exports.VIOLET,
    exports.VIVID_RED,
];
/**
 * Use with caution:
 * This only exists to support deprecated color schemes and
 * is only permitted for usage in a read only manner.
 *
 * @param id - AccentColor ID
 * @returns AccentColor with given ID | undefined
 */
exports.DEPRECATED_getById = (id) => exports.DEPRECATED_ACCENT_COLORS.find(color => color.id === id);
//# sourceMappingURL=AccentColor.js.map