/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import lmcoursier.internal.shaded.coursier.cache.ArtifactError;
import lmcoursier.internal.shaded.coursier.cache.ArtifactError$NotFound$;
import lmcoursier.internal.shaded.coursier.cache.CacheDefaults$;
import lmcoursier.internal.shaded.coursier.cache.CacheLocks$;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger$;
import lmcoursier.internal.shaded.coursier.cache.CacheUrl$;
import lmcoursier.internal.shaded.coursier.cache.FileCache;
import lmcoursier.internal.shaded.coursier.core.Authentication;
import lmcoursier.internal.shaded.coursier.credentials.DirectCredentials;
import lmcoursier.internal.shaded.coursier.paths.CachePath;
import lmcoursier.internal.shaded.coursier.util.Sync;
import lmcoursier.internal.shaded.coursier.util.Task$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class FileCache$ {
    public static FileCache$ MODULE$;
    private final Seq<String> coursier$cache$FileCache$$checksumHeader;

    static {
        new FileCache$();
    }

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull(Predef$.MODULE$.$conforms()), localArtifactsShouldBeCached);
    }

    private String auxiliaryFilePrefix(File file2) {
        return new StringBuilder(3).append(".").append(file2.getName()).append("__").toString();
    }

    public void coursier$cache$FileCache$$clearAuxiliaryFiles(File file2) {
        String prefix = this.auxiliaryFilePrefix(file2);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.getParentFile().listFiles(filter))).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public File auxiliaryFile(File file2, String key) {
        String key0 = (String)new StringOps(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT))).filter((Function1 & Serializable & scala.Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar((Object)x$48))));
        return new File(file2.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix(file2)).append(key0).toString());
    }

    public void coursier$cache$FileCache$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$FileCache$$downloading(String url, File file2, int sslRetry, Function0<Either<ArtifactError, T>> f) {
        return this.helper$2(sslRetry, url, f);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$FileCache$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left left;
        block10: {
            URLConnection conn = null;
            try {
                Left left2;
                URLConnection uRLConnection = conn = CacheUrl$.MODULE$.urlConnection(url, authentication, followHttpToHttpsRedirections, followHttpsToHttpRedirections, credentials, sslSocketFactoryOpt, hostnameVerifierOpt, "HEAD", maxRedirectionsOpt);
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.gettingLength(url);
                    boolean success = false;
                    try {
                        Option len = new Some((Object)BoxesRunTime.boxToLong((long)httpURLConnection.getContentLengthLong())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$50 -> x$50 >= 0L);
                        success = true;
                        logger.gettingLengthResult(url, (Option<Object>)len);
                        right = package$.MODULE$.Right().apply((Object)len);
                    }
                    finally {
                        if (!success) {
                            logger.gettingLengthResult(url, (Option<Object>)None$.MODULE$);
                        }
                    }
                    left2 = right;
                } else {
                    left2 = package$.MODULE$.Left().apply((Object)new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), (Option<Throwable>)None$.MODULE$));
                }
                left = left2;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    CacheUrl$.MODULE$.closeConn(conn);
                }
                throw throwable;
            }
            if (conn == null) break block10;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return new FileCache<F>(new FileCache.Params<F>(CacheDefaults$.MODULE$.location(), CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), (Option<SSLSocketFactory>)None$.MODULE$, (Option<HostnameVerifier>)None$.MODULE$, CacheDefaults$.MODULE$.defaultRetryCount(), CacheDefaults$.MODULE$.bufferSize(), S));
    }

    public <F> Sync<Function1<ExecutionContext, Future<Object>>> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    public Seq<String> coursier$cache$FileCache$$checksumHeader() {
        return this.coursier$cache$FileCache$$checksumHeader;
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$48) {
        return x$48 != '-';
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$6) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$6, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$7, Function0 f$4) {
        Either res;
        Some some;
        block7: {
            while (true) {
                Some resOpt;
                Some some2;
                try {
                    Option res0 = CacheLocks$.MODULE$.withUrlLock(url$7, (Function0 & Serializable & scala.Serializable)() -> {
                        Either either2;
                        try {
                            either2 = (Either)f$4.apply();
                        }
                        catch (Throwable throwable) {
                            FileNotFoundException fileNotFoundException;
                            Throwable throwable2 = throwable;
                            if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw throwable;
                            }
                            Left left = package$.MODULE$.Left().apply((Object)new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                            either2 = left;
                        }
                        return either2;
                    });
                    Either res2 = (Either)res0.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ArtifactError.ConcurrentDownload(url$7)));
                    some2 = new Some((Object)res2);
                }
                catch (Throwable throwable) {
                    None$ none$;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        none$ = None$.MODULE$;
                    } else {
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            none$ = new Some((Object)package$.MODULE$.Left().apply((Object)new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$49 -> new StringBuilder(3).append(" (").append((String)x$49).append(")").toString())).append(" while downloading ").append(url$7).toString(), (Option<Throwable>)new Some((Object)e))));
                        } else {
                            throw throwable;
                        }
                    }
                    some2 = none$;
                }
                some = resOpt = some2;
                if (some instanceof Some) break block7;
                if (!None$.MODULE$.equals(some)) break;
                --retry;
            }
            throw new MatchError((Object)some);
        }
        Some some3 = some;
        Either either2 = res = (Either)some3.value();
        return either2;
    }

    private FileCache$() {
        MODULE$ = this;
        this.coursier$cache$FileCache$$checksumHeader = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MD5", "SHA1", "SHA256"}));
    }
}

