/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository.extractors;

import com.google.common.base.Optional;
import java.io.InputStream;
import java.net.URI;
import org.protege.editor.owl.model.io.IOUtils;
import org.protege.editor.owl.model.repository.extractors.OntologyIdExtractor;
import org.protege.editor.owl.model.repository.extractors.RdfExtractorConsumer;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RdfXmlExtractor
implements OntologyIdExtractor {
    private final Logger logger = LoggerFactory.getLogger(RdfXmlExtractor.class);

    @Override
    public Optional<OWLOntologyID> getOntologyId(URI location) {
        Optional<OWLOntologyID> optional;
        block8: {
            RdfExtractorConsumer consumer = new RdfExtractorConsumer();
            RDFParser parser = new RDFParser();
            InputStream iStream = IOUtils.getInputStream(location, true, 30000);
            try {
                InputSource is = new InputSource(iStream);
                is.setSystemId(location.toURL().toString());
                parser.parse(is, (RDFConsumer)consumer);
                optional = consumer.getOntologyID();
                if (iStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iStream != null) {
                        try {
                            iStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.logger.debug("Exception caught trying to extract ontology from rdf file at  " + location, t);
                    return Optional.absent();
                }
            }
            iStream.close();
        }
        return optional;
    }
}

