/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.math.BigDecimal;
import java.util.Locale;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.ColorScheme;
import processing.mode.java.tweak.HProgressBar;
import processing.mode.java.tweak.TweakClient;

public class Handle {
    public String type;
    public String name;
    public String strValue;
    public String strNewValue;
    public int varIndex;
    public int startChar;
    public int endChar;
    public int newStartChar;
    public int newEndChar;
    public int line;
    int tabIndex;
    int decimalPlaces;
    float incValue;
    Number value;
    Number newValue;
    String strDiff;
    ColorControlBox colorBox;
    int x;
    int y;
    int width;
    int height;
    int xCenter;
    int xCurrent;
    int xLast;
    HProgressBar progBar = null;
    String textFormat;
    TweakClient tweakClient;

    public Handle(String t, String n, int vi, String v, int ti, int l, int sc, int ec, int dp) {
        this.type = t;
        this.name = n;
        this.varIndex = vi;
        this.strValue = v;
        this.tabIndex = ti;
        this.line = l;
        this.startChar = sc;
        this.endChar = ec;
        this.decimalPlaces = dp;
        this.incValue = (float)(1.0 / Math.pow(10.0, this.decimalPlaces));
        if ("int".equals(this.type)) {
            this.value = this.newValue = Integer.valueOf(Integer.parseInt(this.strValue));
            this.strNewValue = this.strValue;
            this.textFormat = "%d";
        } else if ("hex".equals(this.type)) {
            Long val = Long.parseLong(this.strValue.substring(2, this.strValue.length()), 16);
            this.value = this.newValue = Integer.valueOf(val.intValue());
            this.strNewValue = this.strValue;
            this.textFormat = "0x%x";
        } else if ("webcolor".equals(this.type)) {
            Long val = Long.parseLong(this.strValue.substring(1, this.strValue.length()), 16);
            val = val | 0xFFFFFFFFFF000000L;
            this.value = this.newValue = Integer.valueOf(val.intValue());
            this.strNewValue = this.strValue;
            this.textFormat = "#%06x";
        } else if ("float".equals(this.type)) {
            this.value = this.newValue = Float.valueOf(Float.parseFloat(this.strValue));
            this.strNewValue = this.strValue;
            this.textFormat = "%.0" + this.decimalPlaces + "f";
        }
        this.newStartChar = this.startChar;
        this.newEndChar = this.endChar;
    }

    public void initInterface(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.progBar = new HProgressBar(height, width);
    }

    public void setCenterX(int mx) {
        this.xCurrent = this.xCenter = mx;
        this.xLast = this.xCenter;
    }

    public void setCurrentX(int mx) {
        this.xLast = this.xCurrent;
        this.xCurrent = mx;
        this.progBar.setPos(this.xCurrent - this.xCenter);
        this.updateValue();
    }

    public void resetProgress() {
        this.progBar.setPos(0);
    }

    public void updateValue() {
        float change = this.getChange();
        if ("int".equals(this.type)) {
            if (this.newValue.intValue() + (int)change > Integer.MAX_VALUE || this.newValue.intValue() + (int)change < Integer.MIN_VALUE) {
                change = 0.0f;
                return;
            }
            this.setValue(this.newValue.intValue() + (int)change);
        } else if ("hex".equals(this.type)) {
            this.setValue(this.newValue.intValue() + (int)change);
        } else if ("webcolor".equals(this.type)) {
            this.setValue(this.newValue.intValue() + (int)change);
        } else if ("float".equals(this.type)) {
            this.setValue(Float.valueOf(this.newValue.floatValue() + change));
        }
        this.updateColorBox();
    }

    public void setValue(Number value) {
        if ("int".equals(this.type)) {
            this.newValue = value.intValue();
            this.strNewValue = String.format(Locale.US, this.textFormat, this.newValue.intValue());
        } else if ("hex".equals(this.type)) {
            this.newValue = value.intValue();
            this.strNewValue = String.format(Locale.US, this.textFormat, this.newValue.intValue());
        } else if ("webcolor".equals(this.type)) {
            this.newValue = value.intValue();
            int val = this.newValue.intValue() & 0xFFFFFF;
            this.strNewValue = String.format(Locale.US, this.textFormat, val);
        } else if ("float".equals(this.type)) {
            BigDecimal bd = new BigDecimal(value.floatValue());
            bd = bd.setScale(this.decimalPlaces, 4);
            this.newValue = Float.valueOf(bd.floatValue());
            this.strNewValue = String.format(Locale.US, this.textFormat, Float.valueOf(this.newValue.floatValue()));
        }
        this.sendNewValue();
    }

    public void updateColorBox() {
        if (this.colorBox != null) {
            this.colorBox.colorChanged();
        }
    }

    private float getChange() {
        int pixels = this.xCurrent - this.xLast;
        return (float)pixels * this.incValue;
    }

    public void setPos(int nx, int ny) {
        this.x = nx;
        this.y = ny;
    }

    public void setWidth(int w) {
        this.width = w;
        this.progBar.setWidth(w);
    }

    public void draw(Graphics2D g2d, boolean hasFocus) {
        AffineTransform prevTrans = g2d.getTransform();
        g2d.translate(this.x, this.y);
        g2d.setColor(ColorScheme.getInstance().progressFillColor);
        g2d.drawLine(0, 0, this.width, 0);
        if (hasFocus && this.progBar != null) {
            g2d.translate(this.width / 2, 2);
            this.progBar.draw(g2d);
        }
        g2d.setTransform(prevTrans);
    }

    public boolean pick(int mx, int my) {
        return this.pickText(mx, my);
    }

    public boolean pickText(int mx, int my) {
        return mx > this.x - 2 && mx < this.x + this.width + 2 && my > this.y - this.height && my < this.y;
    }

    public boolean valueChanged() {
        if ("int".equals(this.type)) {
            return this.value.intValue() != this.newValue.intValue();
        }
        if ("hex".equals(this.type)) {
            return this.value.intValue() != this.newValue.intValue();
        }
        if ("webcolor".equals(this.type)) {
            return this.value.intValue() != this.newValue.intValue();
        }
        return this.value.floatValue() != this.newValue.floatValue();
    }

    public void setColorBox(ColorControlBox box) {
        this.colorBox = box;
    }

    public void setTweakClient(TweakClient client) {
        this.tweakClient = client;
    }

    public void sendNewValue() {
        int index = this.varIndex;
        try {
            if ("int".equals(this.type)) {
                this.tweakClient.sendInt(index, this.newValue.intValue());
            } else if ("hex".equals(this.type)) {
                this.tweakClient.sendInt(index, this.newValue.intValue());
            } else if ("webcolor".equals(this.type)) {
                this.tweakClient.sendInt(index, this.newValue.intValue());
            } else if ("float".equals(this.type)) {
                this.tweakClient.sendFloat(index, this.newValue.floatValue());
            }
        }
        catch (Exception exception) {
            System.out.println("error sending new value!");
        }
    }

    public String toString() {
        return String.valueOf(this.type) + " " + this.name + " = " + this.strValue + " (tab: " + this.tabIndex + ", line: " + this.line + ", start: " + this.startChar + ", end: " + this.endChar + ")";
    }
}

