/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import com.sun.jdi.Value;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.ExtTreeWillExpandListener;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.mode.java.Debugger;
import processing.mode.java.JavaEditor;
import processing.mode.java.debug.VariableNode;

public class VariableInspector
extends JDialog {
    static final int VERTICAL_OFFSET = 64;
    static final int HORIZONTAL_OFFSET = 16;
    static final int DEFAULT_WIDTH = 300;
    static final int DEFAULT_HEIGHT = 400;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultMutableTreeNode builtins;
    protected DefaultTreeModel treeModel;
    protected Outline tree;
    protected OutlineModel model;
    protected List<DefaultMutableTreeNode> callStack;
    protected List<VariableNode> locals;
    protected List<VariableNode> thisFields;
    protected List<VariableNode> declaredThisFields;
    protected JavaEditor editor;
    protected List<TreePath> expandedNodes = new ArrayList<TreePath>();

    public VariableInspector(JavaEditor editor) {
        super((Frame)((Object)editor), "Variables");
        this.editor = editor;
        this.getRootPane().putClientProperty("Window.style", "small");
        this.setFocusableWindowState(false);
        Box box = Box.createVerticalBox();
        box.add(this.createScrollPane());
        this.getContentPane().add(box);
        this.pack();
        int x = editor.getX() + editor.getWidth() + 16;
        if (x + this.getWidth() > this.getToolkit().getScreenSize().width) {
            this.setLocationRelativeTo((Component)((Object)editor));
        } else {
            this.setLocation(x, editor.getY() + 64);
        }
    }

    Container createScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        this.tree = new Outline();
        scrollPane.setViewportView((Component)this.tree);
        this.rootNode = new DefaultMutableTreeNode("root");
        this.builtins = new DefaultMutableTreeNode("Processing");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.model = DefaultOutlineModel.createOutlineModel((TreeModel)this.treeModel, (RowModel)new VariableRowModel(), (boolean)true, (String)Language.text((String)"debugger.name"));
        ExpansionHandler expansionHandler = new ExpansionHandler();
        this.model.getTreePathSupport().addTreeWillExpandListener((TreeWillExpandListener)((Object)expansionHandler));
        this.model.getTreePathSupport().addTreeExpansionListener((TreeExpansionListener)expansionHandler);
        this.tree.setModel((TableModel)this.model);
        this.tree.setRootVisible(false);
        this.tree.setRenderDataProvider((RenderDataProvider)new OutlineRenderer());
        this.tree.setColumnHidingAllowed(false);
        this.tree.setAutoscrolls(false);
        TableColumn valueColumn = this.tree.getColumnModel().getColumn(1);
        valueColumn.setCellRenderer((TableCellRenderer)((Object)new ValueCellRenderer()));
        valueColumn.setCellEditor(new ValueCellEditor());
        this.callStack = new ArrayList<DefaultMutableTreeNode>();
        this.locals = new ArrayList<VariableNode>();
        this.thisFields = new ArrayList<VariableNode>();
        this.declaredThisFields = new ArrayList<VariableNode>();
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setPreferredSize(new Dimension(300, 400));
        return scrollPane;
    }

    public void unlock() {
        this.tree.setEnabled(true);
    }

    public void lock() {
        if (this.tree.getCellEditor() != null) {
            this.tree.getCellEditor().cancelCellEditing();
        }
        this.tree.setEnabled(false);
    }

    public void reset() {
        this.rootNode.removeAllChildren();
        this.callStack.clear();
        this.locals.clear();
        this.thisFields.clear();
        this.declaredThisFields.clear();
        this.expandedNodes.clear();
        this.treeModel.nodeStructureChanged(this.rootNode);
    }

    public void updateCallStack(List<DefaultMutableTreeNode> nodes, String title) {
        this.callStack = nodes;
    }

    public void updateLocals(List<VariableNode> nodes, String title) {
        this.locals = nodes;
    }

    public void updateThisFields(List<VariableNode> nodes, String title) {
        this.thisFields = nodes;
    }

    public void updateDeclaredThisFields(List<VariableNode> nodes, String title) {
        this.declaredThisFields = nodes;
    }

    public void rebuild() {
        this.rootNode.removeAllChildren();
        this.addAllNodes(this.rootNode, this.locals);
        this.addAllNodes(this.rootNode, this.filterNodes(this.declaredThisFields, new LocalHidesThisFilter(this.locals, 1)));
        this.builtins.removeAllChildren();
        this.addAllNodes(this.builtins, this.filterNodes(this.thisFields, new P5BuiltinsFilter()));
        if (this.builtins.getChildCount() > 0) {
            this.rootNode.add(this.builtins);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        for (TreePath path : this.expandedNodes) {
            if ((path = this.synthesizePath(path)) == null) continue;
            this.tree.expandPath(path);
        }
    }

    protected TreePath synthesizePath(TreePath path) {
        if (path.getPathCount() == 0 || !this.rootNode.equals(path.getPathComponent(0))) {
            return null;
        }
        Object[] newPath = new Object[path.getPathCount()];
        newPath[0] = this.rootNode;
        TreeNode currentNode = this.rootNode;
        int i = 0;
        while (i < path.getPathCount() - 1) {
            int j = 0;
            while (j < currentNode.getChildCount()) {
                TreeNode nextNode = currentNode.getChildAt(j);
                if (nextNode.equals(path.getPathComponent(i + 1))) {
                    currentNode = nextNode;
                    newPath[i + 1] = nextNode;
                    break;
                }
                ++j;
            }
            if (newPath[i + 1] == null) {
                return null;
            }
            ++i;
        }
        return new TreePath(newPath);
    }

    protected List<VariableNode> filterNodes(List<VariableNode> nodes, VariableNodeFilter filter) {
        ArrayList<VariableNode> filtered = new ArrayList<VariableNode>();
        for (VariableNode node : nodes) {
            if (!filter.accept(node)) continue;
            filtered.add(node);
        }
        return filtered;
    }

    protected void addAllNodes(DefaultMutableTreeNode root, List<? extends MutableTreeNode> nodes) {
        for (MutableTreeNode mutableTreeNode : nodes) {
            root.add(mutableTreeNode);
        }
    }

    protected class ExpansionHandler
    implements ExtTreeWillExpandListener,
    TreeExpansionListener {
        protected ExpansionHandler() {
        }

        public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
            Object last = tee.getPath().getLastPathComponent();
            if (!(last instanceof VariableNode)) {
                return;
            }
            VariableNode var = (VariableNode)last;
            var.removeAllChildren();
            var.addChildren(VariableInspector.this.filterNodes(VariableInspector.this.editor.getDebugger().getFields(var.getValue(), 0, true), new ThisFilter()));
        }

        public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent tee) {
            if (!VariableInspector.this.expandedNodes.contains(tee.getPath())) {
                VariableInspector.this.expandedNodes.add(tee.getPath());
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent tee) {
            ArrayList<TreePath> removalList = new ArrayList<TreePath>();
            for (TreePath path : VariableInspector.this.expandedNodes) {
                if (!path.getParentPath().equals(tee.getPath())) continue;
                removalList.add(path);
            }
            for (TreePath path : removalList) {
                VariableInspector.this.expandedNodes.remove(path);
            }
            VariableInspector.this.expandedNodes.remove(tee.getPath());
        }

        public void treeExpansionVetoed(TreeExpansionEvent tee, ExpandVetoException eve) {
        }
    }

    public class LocalHidesThisFilter
    implements VariableNodeFilter {
        public static final int MODE_HIDE = 0;
        public static final int MODE_PREFIX = 1;
        protected List<VariableNode> locals;
        protected int mode;

        public LocalHidesThisFilter(List<VariableNode> locals, int mode) {
            this.locals = locals;
            this.mode = mode;
        }

        @Override
        public boolean accept(VariableNode var) {
            for (VariableNode local : this.locals) {
                if (!var.getName().equals(local.getName())) continue;
                switch (this.mode) {
                    case 1: {
                        var.setName("this." + var.getName());
                        return true;
                    }
                    case 0: {
                        return false;
                    }
                }
            }
            return true;
        }
    }

    class OutlineRenderer
    implements RenderDataProvider {
        Icon[][] icons = this.loadIcons("theme/variables-1x.png");
        static final int ICON_SIZE = 16;

        OutlineRenderer() {
        }

        private ImageIcon[][] loadIcons(String fileName) {
            Mode mode = VariableInspector.this.editor.getMode();
            File file = mode.getContentFile(fileName);
            if (!file.exists()) {
                Messages.log((Object)this.getClass().getName(), (String)("icon file not found: " + file.getAbsolutePath()));
                return null;
            }
            Image allIcons = mode.loadImage(fileName);
            int cols = allIcons.getWidth(null) / 16;
            int rows = allIcons.getHeight(null) / 16;
            ImageIcon[][] iconImages = new ImageIcon[cols][rows];
            int i = 0;
            while (i < cols) {
                int j = 0;
                while (j < rows) {
                    BufferedImage image = new BufferedImage(16, 16, 2);
                    Graphics g = ((Image)image).getGraphics();
                    g.drawImage(allIcons, -i * 16, -j * 16, null);
                    iconImages[i][j] = new ImageIcon(image);
                    ++j;
                }
                ++i;
            }
            return iconImages;
        }

        protected Icon getIcon(int type, int state) {
            if (type < 0 || type > this.icons.length - 1) {
                return null;
            }
            return this.icons[type][state];
        }

        protected VariableNode toVariableNode(Object o) {
            return o instanceof VariableNode ? (VariableNode)o : null;
        }

        protected Icon toGray(Icon icon) {
            if (icon instanceof ImageIcon) {
                Image grayImage = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
                return new ImageIcon(grayImage);
            }
            return icon;
        }

        public String getDisplayName(Object o) {
            return o.toString();
        }

        public boolean isHtmlDisplayName(Object o) {
            return false;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (VariableInspector.this.tree.isEnabled()) {
                return null;
            }
            return Color.GRAY;
        }

        public String getTooltipText(Object o) {
            VariableNode var = this.toVariableNode(o);
            if (var != null) {
                return var.getDescription();
            }
            return "";
        }

        public Icon getIcon(Object o) {
            VariableNode var = this.toVariableNode(o);
            if (var != null) {
                return this.getIcon(var.getType(), VariableInspector.this.tree.isEnabled() ? 0 : 1);
            }
            if (o instanceof TreeNode) {
                UIDefaults defaults = UIManager.getDefaults();
                boolean isLeaf = VariableInspector.this.model.isLeaf(o);
                Icon icon = isLeaf ? defaults.getIcon("Tree.leafIcon") : defaults.getIcon("Tree.closedIcon");
                if (!VariableInspector.this.tree.isEnabled()) {
                    return this.toGray(icon);
                }
                return icon;
            }
            return null;
        }
    }

    public class P5BuiltinsFilter
    implements VariableNodeFilter {
        protected String[] p5Builtins = new String[]{"focused", "frameCount", "frameRate", "height", "online", "screen", "width", "mouseX", "mouseY", "pmouseX", "pmouseY", "key", "keyCode", "keyPressed"};

        @Override
        public boolean accept(VariableNode var) {
            return Arrays.asList(this.p5Builtins).contains(var.getName());
        }
    }

    public class ThisFilter
    implements VariableNodeFilter {
        @Override
        public boolean accept(VariableNode var) {
            return !var.getName().startsWith("this$");
        }
    }

    protected class ValueCellEditor
    extends DefaultCellEditor {
        public ValueCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!(value instanceof VariableNode)) {
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            VariableNode var = (VariableNode)value;
            String strValue = var.getType() == 6 && var.getValue() == null ? "" : var.getStringValue();
            return super.getTableCellEditorComponent(table, strValue, isSelected, row, column);
        }
    }

    protected class ValueCellRenderer
    extends DefaultOutlineCellRenderer {
        protected void setItalic(boolean on) {
            this.setFont(new Font(this.getFont().getName(), on ? 2 : 0, this.getFont().getSize()));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(VariableInspector.this.tree.isEnabled() ? Color.BLACK : Color.GRAY);
            if (value instanceof VariableNode) {
                VariableNode var = (VariableNode)value;
                this.setItalic(var.getValue() == null || var.getType() == 0);
                value = var.getStringValue();
            }
            this.setValue(value);
            return c;
        }
    }

    public static interface VariableNodeFilter {
        public boolean accept(VariableNode var1);
    }

    protected class VariableRowModel
    implements RowModel {
        final String column0 = Language.text((String)"debugger.value");
        final String column1 = Language.text((String)"debugger.type");
        final String[] columnNames = new String[]{this.column0, this.column1};
        final int[] editableTypes = new int[]{4, 3, 2, 6, 3, 8, 7, 10, 5};

        protected VariableRowModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueFor(Object obj, int column) {
            if (obj instanceof VariableNode) {
                VariableNode var = (VariableNode)obj;
                if (column == 0) {
                    return var;
                }
                if (column == 1) {
                    return var.getTypeName();
                }
            }
            return "";
        }

        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return VariableNode.class;
            }
            return String.class;
        }

        public boolean isCellEditable(Object o, int i) {
            if (i == 0 && o instanceof VariableNode) {
                VariableNode var = (VariableNode)o;
                int[] nArray = this.editableTypes;
                int n = this.editableTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    int type = nArray[n2];
                    if (var.getType() == type) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public void setValueFor(Object o, int i, Object o1) {
            VariableNode var = (VariableNode)o;
            String stringValue = (String)o1;
            Debugger dbg = VariableInspector.this.editor.getDebugger();
            Value value = null;
            try {
                switch (var.getType()) {
                    case 2: {
                        value = dbg.vm().mirrorOf(Integer.parseInt(stringValue));
                        break;
                    }
                    case 4: {
                        value = dbg.vm().mirrorOf(Boolean.parseBoolean(stringValue));
                        break;
                    }
                    case 3: {
                        value = dbg.vm().mirrorOf(Float.parseFloat(stringValue));
                        break;
                    }
                    case 6: {
                        value = dbg.vm().mirrorOf(stringValue);
                        break;
                    }
                    case 7: {
                        value = dbg.vm().mirrorOf(Long.parseLong(stringValue));
                        break;
                    }
                    case 9: {
                        value = dbg.vm().mirrorOf(Byte.parseByte(stringValue));
                        break;
                    }
                    case 8: {
                        value = dbg.vm().mirrorOf(Double.parseDouble(stringValue));
                        break;
                    }
                    case 10: {
                        value = dbg.vm().mirrorOf(Short.parseShort(stringValue));
                        break;
                    }
                    case 5: {
                        if (stringValue.length() <= 0) break;
                        value = dbg.vm().mirrorOf(stringValue.charAt(0));
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Messages.log((String)(String.valueOf(this.getClass().getName()) + " invalid value entered for " + var.getName() + " -> " + stringValue));
            }
            if (value != null) {
                var.setValue(value);
                Messages.log((String)(String.valueOf(this.getClass().getName()) + " new value set: " + var.getStringValue()));
            }
        }

        public String getColumnName(int i) {
            return this.columnNames[i];
        }
    }
}

