/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.logstash.Event;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.filters.FieldSetter;
import org.logstash.filters.NumericParserExecutor;
import org.logstash.filters.ParseExecutionResult;
import org.logstash.filters.ParserExecutor;
import org.logstash.filters.ResultSetter;
import org.logstash.filters.TextParserExecutor;
import org.logstash.filters.TimestampSetter;
import org.logstash.filters.parser.CasualISO8601Parser;
import org.logstash.filters.parser.JodaParser;
import org.logstash.filters.parser.TimestampParser;
import org.logstash.filters.parser.TimestampParserFactory;

public class DateFilter {
    private static Logger logger = LogManager.getLogger();
    private final String sourceField;
    private final String[] tagOnFailure;
    private RubyResultHandler successHandler;
    private RubyResultHandler failureHandler;
    private final List<ParserExecutor> executors = new ArrayList<ParserExecutor>();
    private final ResultSetter setter;

    public DateFilter(String sourceField, String targetField, List<String> tagOnFailure, RubyResultHandler successHandler, RubyResultHandler failureHandler) {
        this(sourceField, targetField, tagOnFailure);
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
    }

    public DateFilter(String sourceField, String targetField, List<String> tagOnFailure) {
        this.sourceField = sourceField;
        this.tagOnFailure = tagOnFailure.toArray(new String[0]);
        this.setter = targetField.equals("@timestamp") ? new TimestampSetter() : new FieldSetter(targetField);
    }

    public void acceptFilterConfig(String format, String locale, String timezone) {
        TimestampParser parser = TimestampParserFactory.makeParser(format, locale, timezone);
        logger.debug("Date filter with format={}, locale={}, timezone={} built as {}", (Object)format, (Object)locale, (Object)timezone, (Object)parser.getClass().getName());
        if (parser instanceof JodaParser || parser instanceof CasualISO8601Parser) {
            this.executors.add(new TextParserExecutor(parser, timezone));
        } else {
            this.executors.add(new NumericParserExecutor(parser));
        }
    }

    public List<JrubyEventExtLibrary.RubyEvent> receive(List<JrubyEventExtLibrary.RubyEvent> rubyEvents) {
        block4: for (JrubyEventExtLibrary.RubyEvent rubyEvent : rubyEvents) {
            Event event = rubyEvent.getEvent();
            switch (this.executeParsers(event)) {
                case FIELD_VALUE_IS_NULL_OR_FIELD_NOT_PRESENT: 
                case IGNORED: {
                    continue block4;
                }
                case SUCCESS: {
                    if (this.successHandler == null) continue block4;
                    this.successHandler.handle(rubyEvent);
                    continue block4;
                }
            }
            for (String t : this.tagOnFailure) {
                event.tag(t);
            }
            if (this.failureHandler == null) continue;
            this.failureHandler.handle(rubyEvent);
        }
        return rubyEvents;
    }

    public ParseExecutionResult executeParsers(Event event) {
        Object input = event.getField(this.sourceField);
        if (event.isCancelled()) {
            return ParseExecutionResult.IGNORED;
        }
        if (input == null) {
            return ParseExecutionResult.FIELD_VALUE_IS_NULL_OR_FIELD_NOT_PRESENT;
        }
        for (ParserExecutor executor : this.executors) {
            try {
                Instant instant = executor.execute(input, event);
                this.setter.set(event, instant);
                return ParseExecutionResult.SUCCESS;
            }
            catch (IOException | IllegalArgumentException exception) {
            }
        }
        return ParseExecutionResult.FAIL;
    }

    public static interface RubyResultHandler {
        public void handle(JrubyEventExtLibrary.RubyEvent var1);
    }
}

