/*
 * Decompiled with CFR 0.152.
 */
package snappy;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.xerial.snappy.Snappy;

@JRubyModule(name={"Snappy"})
public class SnappyModule {
    @JRubyMethod(module=true, name={"deflate", "compress", "dump"})
    public static IRubyObject deflate(ThreadContext context, IRubyObject self, IRubyObject str) throws IOException {
        ByteList input = str.convertToString().getByteList();
        byte[] compressed = new byte[Snappy.maxCompressedLength((int)input.length())];
        int compressedLength = Snappy.compress((byte[])input.unsafeBytes(), (int)input.begin(), (int)input.length(), (byte[])compressed, (int)0);
        return RubyString.newStringNoCopy((Ruby)context.runtime, (byte[])compressed, (int)0, (int)compressedLength);
    }

    @JRubyMethod(module=true, name={"inflate", "uncompress", "load"})
    public static IRubyObject inflate(ThreadContext context, IRubyObject self, IRubyObject str) throws IOException {
        ByteList input = str.convertToString().getByteList();
        byte[] uncompressed = new byte[Snappy.uncompressedLength((byte[])input.unsafeBytes(), (int)input.begin(), (int)input.length())];
        int uncompressedLength = Snappy.uncompress((byte[])input.unsafeBytes(), (int)input.begin(), (int)input.length(), (byte[])uncompressed, (int)0);
        return RubyString.newStringNoCopy((Ruby)context.runtime, (byte[])uncompressed, (int)0, (int)uncompressedLength);
    }
}

