/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import java.text.Bidi;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.i18n.I18n;
import writer2latex.latex.i18n.Polyglossia;
import writer2latex.latex.i18n.ReplacementTrieNode;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;

public class XeTeXI18n
extends I18n {
    private Polyglossia polyglossia = new Polyglossia();
    private boolean bLTR;
    private boolean bUseXepersian;
    private String sLTRCommand = null;
    private String sRTLCommand = null;

    public XeTeXI18n(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        boolean bl = this.bLTR = !"fa".equals(this.sDefaultCTLLanguage) && !"he".equals(this.sDefaultCTLLanguage);
        if (this.bLTR) {
            this.polyglossia.applyLanguage(this.sDefaultLanguage, this.sDefaultCountry);
        } else {
            this.polyglossia.applyLanguage(this.sDefaultCTLLanguage, this.sDefaultCTLCountry);
        }
        this.bUseXepersian = "fa".equals(this.sDefaultCTLLanguage);
        if (this.bUseXepersian) {
            this.sLTRCommand = "\\lr";
            this.sRTLCommand = "\\rl";
        }
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        pack.append("\\usepackage{amsmath,amssymb,amsfonts}").nl().append("\\usepackage{fontspec}").nl().append("\\usepackage{xunicode}").nl().append("\\usepackage{xltxtra}").nl();
        if (!this.bUseXepersian) {
            String[] polyglossiaDeclarations;
            for (String s : polyglossiaDeclarations = this.polyglossia.getDeclarations()) {
                decl.append(s).nl();
            }
            if (!this.bLTR) {
                decl.append("\\setmainfont[Script=Hebrew]{Frank Ruehl CLM}").nl();
                decl.append("\\setsansfont[Script=Hebrew]{Nachlieli CLM}").nl();
                decl.append("\\setmonofont[Script=Hebrew]{Miriam Mono CLM}").nl();
            }
        } else {
            String sDefaultCTLFont;
            decl.append("\\usepackage{xepersian}").nl();
            StyleWithProperties defaultStyle = this.ofr.getDefaultParStyle();
            if (defaultStyle != null && (sDefaultCTLFont = defaultStyle.getProperty("style:font-name-complex")) != null) {
                decl.append("\\settextfont{").append(sDefaultCTLFont).append("}").nl();
            }
        }
    }

    @Override
    public void applyLanguage(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba) {
        if (this.bLTR && !this.bAlwaysUseDefaultLang && style != null) {
            String sISOLang = style.getProperty("fo:language", bInherit);
            String sISOCountry = style.getProperty("fo:country", bInherit);
            if (sISOLang != null) {
                String[] sCommand = this.polyglossia.applyLanguage(sISOLang, sISOCountry);
                if (bDecl) {
                    ba.add(sCommand[1], sCommand[2]);
                } else {
                    ba.add(sCommand[0] + "{", "}");
                }
            }
        }
    }

    @Override
    public void pushSpecialTable(String sName) {
    }

    @Override
    public void popSpecialTable() {
    }

    @Override
    public String convert(String s, boolean bMathMode, String sLang) {
        StringBuilder buf = new StringBuilder();
        int nLen = s.length();
        if (bMathMode) {
            for (int i = 0; i < nLen; ++i) {
                this.convert(s.charAt(i), buf);
            }
        } else if (!this.bUseXepersian) {
            int i = 0;
            while (i < nLen) {
                ReplacementTrieNode node = this.stringReplace.get(s, i, nLen);
                if (node != null) {
                    buf.append(node.getLaTeXCode());
                    i += node.getInputLength();
                    continue;
                }
                char c = s.charAt(i++);
                this.convert(c, buf);
            }
        } else {
            Bidi bidi = new Bidi(s, 1);
            int nCurrentLevel = bidi.getBaseLevel();
            int nNestingLevel = 0;
            for (int i = 0; i < nLen; ++i) {
                int nLevel = bidi.getLevelAt(i);
                if (nLevel > nCurrentLevel) {
                    if (nLevel % 2 == 0) {
                        buf.append(this.sLTRCommand).append("{");
                    } else {
                        buf.append(this.sRTLCommand).append("{");
                    }
                    nCurrentLevel = nLevel;
                    ++nNestingLevel;
                } else if (nLevel < nCurrentLevel) {
                    buf.append("}");
                    nCurrentLevel = nLevel;
                    --nNestingLevel;
                }
                this.convert(s.charAt(i), buf);
            }
            while (nNestingLevel > 0) {
                buf.append("}");
                --nNestingLevel;
            }
        }
        return buf.toString();
    }

    private void convert(char c, StringBuilder buf) {
        switch (c) {
            case '#': {
                buf.append("\\#");
                break;
            }
            case '$': {
                buf.append("\\$");
                break;
            }
            case '%': {
                buf.append("\\%");
                break;
            }
            case '&': {
                buf.append("\\&");
                break;
            }
            case '\\': {
                buf.append("\\textbackslash{}");
                break;
            }
            case '^': {
                buf.append("\\^{}");
                break;
            }
            case '_': {
                buf.append("\\_");
                break;
            }
            case '{': {
                buf.append("\\{");
                break;
            }
            case '}': {
                buf.append("\\}");
                break;
            }
            case '~': {
                buf.append("\\textasciitilde{}");
                break;
            }
            case '\u00a0': {
                buf.append('~');
                break;
            }
            default: {
                buf.append(c);
            }
        }
    }
}

