"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndexPatterns = fetchIndexPatterns;

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _static_utils = require("ui/index_patterns/static_utils");

var _lodash = require("lodash");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var config = _chrome.default.getUiSettingsClient();

function fetchIndexPatterns(_x) {
  return _fetchIndexPatterns.apply(this, arguments);
}

function _fetchIndexPatterns() {
  _fetchIndexPatterns = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee2(indexPatternStrings) {
    var searchString, indexPatternsFromSavedObjects, exactMatches, allMatches;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            if (!(!indexPatternStrings || (0, _lodash.isEmpty)(indexPatternStrings))) {
              _context2.next = 2;
              break;
            }

            return _context2.abrupt("return", []);

          case 2:
            searchString = indexPatternStrings.map(function (string) {
              return "\"".concat(string, "\"");
            }).join(' | ');
            _context2.next = 5;
            return _chrome.default.getSavedObjectsClient().find({
              type: 'index-pattern',
              fields: ['title', 'fields'],
              search: searchString,
              searchFields: ['title']
            });

          case 5:
            indexPatternsFromSavedObjects = _context2.sent;
            exactMatches = indexPatternsFromSavedObjects.savedObjects.filter(function (savedObject) {
              return indexPatternStrings.includes(savedObject.attributes.title);
            });

            if (!(exactMatches.length === indexPatternStrings.length)) {
              _context2.next = 11;
              break;
            }

            _context2.t0 = exactMatches;
            _context2.next = 18;
            break;

          case 11:
            _context2.t1 = [];
            _context2.t2 = _toConsumableArray(exactMatches);
            _context2.next = 15;
            return fetchDefaultIndexPattern();

          case 15:
            _context2.t3 = _context2.sent;
            _context2.t4 = [_context2.t3];
            _context2.t0 = _context2.t1.concat.call(_context2.t1, _context2.t2, _context2.t4);

          case 18:
            allMatches = _context2.t0;
            return _context2.abrupt("return", allMatches.map(_static_utils.getFromSavedObject));

          case 20:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _fetchIndexPatterns.apply(this, arguments);
}

var fetchDefaultIndexPattern =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee() {
    var savedObjectsClient;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            savedObjectsClient = _chrome.default.getSavedObjectsClient();
            _context.next = 3;
            return savedObjectsClient.get('index-pattern', config.get('defaultIndex'));

          case 3:
            return _context.abrupt("return", _context.sent);

          case 4:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function fetchDefaultIndexPattern() {
    return _ref.apply(this, arguments);
  };
}();