export function get2v(F) {
    return s => F.of([s, s]);
}
export function put(F) {
    return s => () => F.of([undefined, s]);
}
export function modify(F) {
    return f => s => F.of([undefined, f(s)]);
}
export function gets(F) {
    return f => s => F.of([f(s), s]);
}
export function fromState(F) {
    return fa => s => F.of(fa.run(s));
}
export function liftF(F) {
    return fa => s => F.map(fa, a => [a, s]);
}
export function getStateT2v(M) {
    return {
        map: (fa, f) => s => M.map(fa(s), ([a, s1]) => [f(a), s1]),
        of: a => s => M.of([a, s]),
        ap: (fab, fa) => s => M.chain(fab(s), ([f, s]) => M.map(fa(s), ([a, s]) => [f(a), s])),
        chain: (fa, f) => s => M.chain(fa(s), ([a, s1]) => f(a)(s1))
    };
}
/** @deprecated */
export function map(F) {
    return (f, fa) => s => F.map(fa(s), ([a, s1]) => [f(a), s1]);
}
/** @deprecated */
export function ap(F) {
    return (fab, fa) => s => F.chain(fab(s), ([f, s]) => F.map(fa(s), ([a, s]) => [f(a), s]));
}
/** @deprecated */
export function chain(F) {
    return (f, fa) => s => F.chain(fa(s), ([a, s1]) => f(a)(s1));
}
/** @deprecated */
// tslint:disable-next-line: deprecation
export function getStateT(M) {
    return {
        // tslint:disable-next-line: deprecation
        map: map(M),
        // tslint:disable-next-line: deprecation
        of: of(M),
        // tslint:disable-next-line: deprecation
        ap: ap(M),
        // tslint:disable-next-line: deprecation
        chain: chain(M)
    };
}
/** @deprecated */
export function of(F) {
    return a => s => F.of([a, s]);
}
/** @deprecated */
export function get(F) {
    return () => s => F.of([s, s]);
}
