"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var series_1 = require("./series");
function getSeriesTooltipValues(tooltipValues) {
    // map from seriesKey to tooltipValue
    var seriesTooltipValues = new Map();
    // First tooltipValue is the header
    if (tooltipValues.length <= 1) {
        return seriesTooltipValues;
    }
    tooltipValues.slice(1).forEach(function (tooltipValue) {
        var seriesKey = tooltipValue.seriesKey, value = tooltipValue.value;
        seriesTooltipValues.set(seriesKey, value);
    });
    return seriesTooltipValues;
}
exports.getSeriesTooltipValues = getSeriesTooltipValues;
function formatTooltip(searchIndexValue, spec, isXValue, isHighlighted, axisSpec) {
    var id = spec.id;
    var color = searchIndexValue.color, _a = searchIndexValue.value, x = _a.x, y = _a.y, seriesKey = searchIndexValue.geometryId.seriesKey;
    var seriesKeyAsString = series_1.getColorValuesAsString(seriesKey, id);
    var name;
    if (seriesKey.length > 0) {
        name = seriesKey.join(' - ');
    }
    else {
        name = spec.name || "" + spec.id;
    }
    var value = isXValue ? x : y;
    return {
        seriesKey: seriesKeyAsString,
        name: name,
        value: axisSpec ? axisSpec.tickFormat(value) : emptyFormatter(value),
        color: color,
        isHighlighted: isXValue ? false : isHighlighted,
        isXValue: isXValue,
    };
}
exports.formatTooltip = formatTooltip;
function emptyFormatter(value) {
    return value;
}
//# sourceMappingURL=tooltip.js.map