"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Option_1 = require("fp-ts/lib/Option");
var CanvasTextBBoxCalculator = /** @class */ (function () {
    function CanvasTextBBoxCalculator(rootElement, scaledFontSize) {
        if (scaledFontSize === void 0) { scaledFontSize = 100; }
        this.offscreenCanvas = document.createElement('canvas');
        this.offscreenCanvas.style.position = 'absolute';
        this.offscreenCanvas.style.top = '-9999px';
        this.context = this.offscreenCanvas.getContext('2d');
        this.attachedRoot = rootElement || document.documentElement;
        this.attachedRoot.appendChild(this.offscreenCanvas);
        this.scaledFontSize = scaledFontSize;
    }
    CanvasTextBBoxCalculator.prototype.compute = function (text, fontSize, fontFamily, padding) {
        if (fontSize === void 0) { fontSize = 16; }
        if (fontFamily === void 0) { fontFamily = 'Arial'; }
        if (padding === void 0) { padding = 1; }
        if (!this.context) {
            return Option_1.none;
        }
        // We scale the text up to get a more accurate computation of the width of the text
        // because `measureText` can vary a lot between browsers.
        var scalingFactor = this.scaledFontSize / fontSize;
        this.context.font = this.scaledFontSize + "px " + fontFamily;
        var measure = this.context.measureText(text);
        return Option_1.some({
            width: measure.width / scalingFactor + padding,
            height: fontSize,
        });
    };
    CanvasTextBBoxCalculator.prototype.destroy = function () {
        this.attachedRoot.removeChild(this.offscreenCanvas);
    };
    return CanvasTextBBoxCalculator;
}());
exports.CanvasTextBBoxCalculator = CanvasTextBBoxCalculator;
//# sourceMappingURL=canvas_text_bbox_calculator.js.map