/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.MavenVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.MavenPublishingAwareContext;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.java.JavaLibraryPlatform;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;
import org.gradle.api.publish.maven.internal.artifact.DerivedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.SingleOutputTaskMavenArtifact;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.CollectionUtils;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

public class DefaultMavenPublication
implements MavenPublicationInternal {
    private static final Logger LOG = Logging.getLogger(DefaultMavenPublication.class);
    private static final String API_VARIANT = "api";
    private static final String API_ELEMENTS_VARIANT = "apiElements";
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private static final Comparator<String> VARIANT_ORDERING = (left, right) -> {
        if (API_VARIANT.equals(left) || API_ELEMENTS_VARIANT.equals(left)) {
            return -1;
        }
        if (API_VARIANT.equals(right) || API_ELEMENTS_VARIANT.equals(right)) {
            return 1;
        }
        return left.compareTo((String)right);
    };
    @VisibleForTesting
    public static final String INCOMPATIBLE_FEATURE = " contains dependencies that will produce a pom file that cannot be consumed by a Maven client.";
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published pom file.";
    private final String name;
    private final MavenPomInternal pom;
    private final MutableMavenProjectIdentity projectIdentity;
    private final DefaultMavenArtifactSet mainArtifacts;
    private final PublicationArtifactSet<MavenArtifact> metadataArtifacts;
    private final PublicationArtifactSet<MavenArtifact> derivedArtifacts;
    private final PublicationArtifactSet<MavenArtifact> publishableArtifacts;
    private final Set<MavenDependencyInternal> runtimeDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependencyInternal> apiDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependencyInternal> optionalDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final Set<MavenDependency> runtimeDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final Set<MavenDependency> apiDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final Set<MavenDependency> importDependencyConstraints = new LinkedHashSet<MavenDependency>();
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FeaturePreviews featurePreviews;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final PlatformSupport platformSupport;
    private MavenArtifact pomArtifact;
    private SingleOutputTaskMavenArtifact moduleMetadataArtifact;
    private TaskProvider<? extends Task> moduleDescriptorGenerator;
    private SoftwareComponentInternal component;
    private boolean isPublishWithOriginalFileName;
    private boolean alias;
    private boolean populated;
    private boolean artifactsOverridden;
    private boolean versionMappingInUse = false;

    @Inject
    public DefaultMavenPublication(String name, MutableMavenProjectIdentity projectIdentity, NotationParser<Object, MavenArtifact> mavenArtifactParser, Instantiator instantiator, ObjectFactory objectFactory, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, FeaturePreviews featurePreviews, ImmutableAttributesFactory immutableAttributesFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator, VersionMappingStrategyInternal versionMappingStrategy, PlatformSupport platformSupport) {
        this.name = name;
        this.projectDependencyResolver = projectDependencyResolver;
        this.projectIdentity = projectIdentity;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.versionMappingStrategy = versionMappingStrategy;
        this.platformSupport = platformSupport;
        this.mainArtifacts = (DefaultMavenArtifactSet)instantiator.newInstance(DefaultMavenArtifactSet.class, new Object[]{name, mavenArtifactParser, fileCollectionFactory, collectionCallbackActionDecorator});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "metadata artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(MavenArtifact.class, "derived artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.publishableArtifacts = new CompositePublicationArtifactSet(MavenArtifact.class, new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts});
        this.pom = (MavenPomInternal)instantiator.newInstance(DefaultMavenPom.class, new Object[]{this, instantiator, objectFactory});
        this.featurePreviews = featurePreviews;
    }

    public String getName() {
        return this.name;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((String)"Maven publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public MavenPomInternal getPom() {
        return this.pom;
    }

    @Override
    public void setPomGenerator(TaskProvider<? extends Task> pomGenerator) {
        if (this.pomArtifact != null) {
            this.metadataArtifacts.remove((Object)this.pomArtifact);
        }
        this.pomArtifact = new SingleOutputTaskMavenArtifact(pomGenerator, "pom", null);
        this.metadataArtifacts.add((Object)this.pomArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.moduleMetadataArtifact != null) {
            this.metadataArtifacts.remove((Object)this.moduleMetadataArtifact);
        }
        this.moduleMetadataArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.moduleMetadataArtifact = new SingleOutputTaskMavenArtifact(this.moduleDescriptorGenerator, "module", null);
        this.metadataArtifacts.add((Object)this.moduleMetadataArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void pom(Action<? super MavenPom> configure) {
        configure.execute((Object)this.pom);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Maven publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        if (component instanceof JavaLibraryPlatform) {
            DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause((String)"components.javaLibraryPlatform", (String)"Use the 'java-platform' plugin instead.");
        }
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (this.component == null) {
            return;
        }
        PublicationWarningsCollector publicationWarningsCollector = new PublicationWarningsCollector(LOG, UNSUPPORTED_FEATURE, INCOMPATIBLE_FEATURE);
        HashSet seenArtifacts = Sets.newHashSet();
        HashSet seenDependencies = Sets.newHashSet();
        HashSet seenConstraints = Sets.newHashSet();
        for (UsageContext usageContext : this.getSortedUsageContexts()) {
            for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                ArtifactKey key = new ArtifactKey(publishArtifact.getFile(), publishArtifact.getClassifier(), publishArtifact.getExtension());
                if (this.artifactsOverridden || !seenArtifacts.add(key)) continue;
                this.artifact(publishArtifact);
            }
            Set globalExcludes = usageContext.getGlobalExcludes();
            Set<MavenDependencyInternal> dependencies = this.dependenciesFor(usageContext);
            for (ModuleDependency dependency : usageContext.getDependencies()) {
                if (!seenDependencies.add(PublishedDependency.of(dependency))) continue;
                if (this.platformSupport.isTargettingPlatform((HasConfigurableAttributes)dependency)) {
                    if (dependency instanceof ProjectDependency) {
                        this.addImportDependencyConstraint((ProjectDependency)dependency);
                        continue;
                    }
                    if (!this.versionMappingInUse && this.isVersionMavenIncompatible(dependency.getVersion())) {
                        publicationWarningsCollector.addIncompatible(String.format("%s:%s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                    }
                    this.addImportDependencyConstraint(dependency);
                    continue;
                }
                if (!dependency.getAttributes().isEmpty()) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                if (dependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)dependency, globalExcludes, dependencies);
                    continue;
                }
                if (!this.versionMappingInUse && this.isVersionMavenIncompatible(dependency.getVersion())) {
                    publicationWarningsCollector.addIncompatible(String.format("%s:%s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                this.addModuleDependency(dependency, globalExcludes, dependencies);
            }
            Set<MavenDependency> dependencyConstraints = this.dependencyConstraintsFor(usageContext);
            for (DependencyConstraint dependency : usageContext.getDependencyConstraints()) {
                if (!seenConstraints.add(dependency) || dependency.getVersion() == null) continue;
                if (!this.versionMappingInUse && this.isVersionMavenIncompatible(dependency.getVersion())) {
                    publicationWarningsCollector.addIncompatible(String.format("constraint %s:%s:%s declared with a Maven incompatible version notation", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                this.addDependencyConstraint(dependency, dependencyConstraints);
            }
            if (usageContext.getCapabilities().isEmpty()) continue;
            for (Capability capability : usageContext.getCapabilities()) {
                publicationWarningsCollector.addUnsupported(String.format("Declares capability %s:%s:%s", capability.getGroup(), capability.getName(), capability.getVersion()));
            }
        }
        publicationWarningsCollector.complete(this.getDisplayName());
    }

    private boolean isVersionMavenIncompatible(String version) {
        if (version == null) {
            return false;
        }
        if (version.contains("+")) {
            return true;
        }
        if (version.contains("latest")) {
            return !MavenVersionSelectorScheme.isSubstituableLatest((String)version);
        }
        return false;
    }

    private void addImportDependencyConstraint(ProjectDependency dependency) {
        ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
        this.importDependencyConstraints.add(new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), "pom"));
    }

    private void addImportDependencyConstraint(ModuleDependency dependency) {
        this.importDependencyConstraints.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), "pom"));
    }

    private List<UsageContext> getSortedUsageContexts() {
        ArrayList usageContexts = Lists.newArrayList((Iterable)this.component.getUsages());
        if (this.component instanceof AdhocComponentWithVariants) {
            Collections.sort((List)Cast.uncheckedCast((Object)usageContexts), Comparator.comparing(MavenPublishingAwareContext::getScopeMapping));
        } else {
            Collections.sort(usageContexts, (u1, u2) -> VARIANT_ORDERING.compare(u1.getName(), u2.getName()));
        }
        return usageContexts;
    }

    private Set<MavenDependencyInternal> dependenciesFor(UsageContext usage) {
        String name;
        if (usage instanceof MavenPublishingAwareContext) {
            MavenPublishingAwareContext.ScopeMapping mapping = ((MavenPublishingAwareContext)usage).getScopeMapping();
            switch (mapping) {
                case compile: {
                    return this.apiDependencies;
                }
                case runtime: {
                    return this.runtimeDependencies;
                }
                case compile_optional: 
                case runtime_optional: {
                    return this.optionalDependencies;
                }
            }
        }
        if (API_VARIANT.equals(name = usage.getName()) || API_ELEMENTS_VARIANT.equals(name)) {
            return this.apiDependencies;
        }
        return this.runtimeDependencies;
    }

    private Set<MavenDependency> dependencyConstraintsFor(UsageContext usage) {
        String name;
        if (usage instanceof MavenPublishingAwareContext) {
            MavenPublishingAwareContext.ScopeMapping mapping = ((MavenPublishingAwareContext)usage).getScopeMapping();
            switch (mapping) {
                case compile: 
                case compile_optional: {
                    return this.apiDependencyConstraints;
                }
                case runtime: 
                case runtime_optional: {
                    return this.runtimeDependencyConstraints;
                }
            }
        }
        if (API_VARIANT.equals(name = usage.getName()) || API_ELEMENTS_VARIANT.equals(name)) {
            return this.apiDependencyConstraints;
        }
        return this.runtimeDependencyConstraints;
    }

    private void addProjectDependency(ProjectDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
        ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
        dependencies.add(new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), Collections.emptyList(), DefaultMavenPublication.getExcludeRules(globalExcludes, (ModuleDependency)dependency)));
    }

    private void addModuleDependency(ModuleDependency dependency, Set<ExcludeRule> globalExcludes, Set<MavenDependencyInternal> dependencies) {
        dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), dependency.getArtifacts(), DefaultMavenPublication.getExcludeRules(globalExcludes, dependency)));
    }

    private void addDependencyConstraint(DependencyConstraint dependency, Set<MavenDependency> dependencies) {
        dependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion()));
    }

    private static Set<ExcludeRule> getExcludeRules(Set<ExcludeRule> globalExcludes, ModuleDependency dependency) {
        return dependency.isTransitive() ? Sets.union(globalExcludes, (Set)dependency.getExcludeRules()) : EXCLUDE_ALL_RULE;
    }

    @Override
    public MavenArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public MavenArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public String getGroupId() {
        return (String)this.projectIdentity.getGroupId().get();
    }

    @Override
    public void setGroupId(String groupId) {
        this.projectIdentity.getGroupId().set((Object)groupId);
    }

    @Override
    public String getArtifactId() {
        return (String)this.projectIdentity.getArtifactId().get();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.projectIdentity.getArtifactId().set((Object)artifactId);
    }

    @Override
    public String getVersion() {
        return (String)this.projectIdentity.getVersion().get();
    }

    @Override
    public void setVersion(String version) {
        this.projectIdentity.getVersion().set((Object)version);
    }

    @Override
    public void versionMapping(Action<? super VersionMappingStrategy> configureAction) {
        this.versionMappingInUse = true;
        configureAction.execute((Object)this.versionMappingStrategy);
    }

    @Override
    @Nullable
    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.versionMappingStrategy;
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.canPublishModuleMetadata() && this.moduleMetadataArtifact != null && this.moduleMetadataArtifact.isEnabled();
    }

    @Override
    public FileCollection getPublishableFiles() {
        return this.getPublishableArtifacts().getFiles();
    }

    public PublicationArtifactSet<MavenArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super MavenArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public MavenArtifact addDerivedArtifact(MavenArtifact originalArtifact, Factory<File> file) {
        DerivedMavenArtifact artifact = new DerivedMavenArtifact(originalArtifact, file);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(MavenArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public MutableMavenProjectIdentity getMavenProjectIdentity() {
        return this.projectIdentity;
    }

    @Override
    public Set<MavenDependency> getApiDependencyConstraints() {
        this.populateFromComponent();
        return this.apiDependencyConstraints;
    }

    @Override
    public Set<MavenDependency> getRuntimeDependencyConstraints() {
        this.populateFromComponent();
        return this.runtimeDependencyConstraints;
    }

    @Override
    public Set<MavenDependency> getImportDependencyConstraints() {
        this.populateFromComponent();
        return this.importDependencyConstraints;
    }

    @Override
    public Set<MavenDependencyInternal> getRuntimeDependencies() {
        this.populateFromComponent();
        return this.runtimeDependencies;
    }

    @Override
    public Set<MavenDependencyInternal> getApiDependencies() {
        this.populateFromComponent();
        return this.apiDependencies;
    }

    @Override
    public Set<MavenDependencyInternal> getOptionalDependencies() {
        this.populateFromComponent();
        return this.optionalDependencies;
    }

    @Override
    public MavenNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        DomainObjectSet existingDerivedArtifacts = this.derivedArtifacts.matching((Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact artifact) {
                return artifact.getFile().exists();
            }
        });
        DomainObjectSet artifactsToBePublished = CompositeDomainObjectSet.create(MavenArtifact.class, (DomainObjectCollection[])new DomainObjectCollection[]{this.mainArtifacts, this.metadataArtifacts, existingDerivedArtifacts}).matching((Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact element) {
                if (DefaultMavenPublication.this.moduleMetadataArtifact == element) {
                    return DefaultMavenPublication.this.moduleMetadataArtifact.isEnabled();
                }
                return true;
            }
        });
        return new MavenNormalizedPublication(this.name, this.projectIdentity, this.pom.getPackaging(), this.getPomArtifact(), this.determineMainArtifact(), (Set<MavenArtifact>)artifactsToBePublished);
    }

    private MavenArtifact getPomArtifact() {
        if (this.pomArtifact == null) {
            throw new IllegalStateException("pomArtifact not set for publication");
        }
        return this.pomArtifact;
    }

    @Override
    public String determinePackagingFromArtifacts() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next().getExtension();
        }
        return "pom";
    }

    private MavenArtifact determineMainArtifact() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.isEmpty()) {
            return null;
        }
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next();
        }
        for (MavenArtifact unclassifiedArtifact : unclassifiedArtifacts) {
            String packaging = this.pom.getPackaging();
            if (!unclassifiedArtifact.getExtension().equals(packaging)) continue;
            return unclassifiedArtifact;
        }
        return null;
    }

    private Set<MavenArtifact> getUnclassifiedArtifactsWithExtension() {
        this.populateFromComponent();
        return CollectionUtils.filter((Set)((Object)this.mainArtifacts), (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact mavenArtifact) {
                return DefaultMavenPublication.this.hasNoClassifier(mavenArtifact) && DefaultMavenPublication.this.hasExtension(mavenArtifact);
            }
        });
    }

    private boolean hasNoClassifier(MavenArtifact element) {
        return element.getClassifier() == null || element.getClassifier().length() == 0;
    }

    private boolean hasExtension(MavenArtifact element) {
        return element.getExtension() != null && element.getExtension().length() > 0;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getVersion());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    @Override
    public void publishWithOriginalFileName() {
        this.isPublishWithOriginalFileName = true;
    }

    private boolean canPublishModuleMetadata() {
        if (this.getComponent() == null) {
            return false;
        }
        if (this.getComponent() instanceof ComponentWithVariants) {
            return true;
        }
        return this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA);
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        this.checkThatArtifactIsPublishedUnmodified(source);
        final String publishedUrl = this.getPublishedUrl(source);
        final String publishedName = this.isPublishWithOriginalFileName ? source.getFile().getName() : publishedUrl;
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedName;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Nullable
    public ImmutableAttributes getAttributes() {
        String version = (String)this.getMavenProjectIdentity().getVersion().get();
        String status = MavenVersionUtils.inferStatusFromVersionNumber((String)version);
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
    }

    private void checkThatArtifactIsPublishedUnmodified(PublishArtifact source) {
        this.populateFromComponent();
        Iterator iterator = this.mainArtifacts.iterator();
        while (iterator.hasNext()) {
            MavenArtifact mavenArtifact = (MavenArtifact)iterator.next();
            if (!source.getFile().equals(mavenArtifact.getFile()) || !source.getExtension().equals(mavenArtifact.getExtension()) || !Strings.nullToEmpty((String)source.getClassifier()).equals(Strings.nullToEmpty((String)mavenArtifact.getClassifier()))) continue;
            return;
        }
        throw new PublishException("Cannot publish module metadata where component artifacts are modified.");
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    private static class PublishedDependency {
        private final String group;
        private final String name;
        private final String targetConfiguration;
        private final AttributeContainer attributes;
        private final Set<DependencyArtifact> artifacts;
        private final Set<ExcludeRule> excludeRules;
        private final List<Capability> requestedCapabilities;

        private PublishedDependency(String group, String name, String targetConfiguration, AttributeContainer attributes, Set<DependencyArtifact> artifacts, Set<ExcludeRule> excludeRules, List<Capability> requestedCapabilities) {
            this.group = group;
            this.name = name;
            this.targetConfiguration = targetConfiguration;
            this.attributes = attributes;
            this.artifacts = artifacts;
            this.excludeRules = excludeRules;
            this.requestedCapabilities = requestedCapabilities;
        }

        static PublishedDependency of(ModuleDependency dep) {
            return new PublishedDependency(dep.getGroup(), dep.getName(), dep.getTargetConfiguration(), dep.getAttributes(), dep.getArtifacts(), dep.getExcludeRules(), dep.getRequestedCapabilities());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PublishedDependency that = (PublishedDependency)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.targetConfiguration, (Object)that.targetConfiguration) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.artifacts, that.artifacts) && Objects.equal(this.excludeRules, that.excludeRules) && Objects.equal(this.requestedCapabilities, that.requestedCapabilities);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.name, this.targetConfiguration, this.attributes, this.artifacts, this.excludeRules, this.requestedCapabilities});
        }
    }

    private static class ArtifactKey {
        final File file;
        final String classifier;
        final String extension;

        public ArtifactKey(File file, String classifier, String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public boolean equals(Object obj) {
            ArtifactKey other = (ArtifactKey)obj;
            return this.file.equals(other.file) && Objects.equal((Object)this.classifier, (Object)other.classifier) && Objects.equal((Object)this.extension, (Object)other.extension);
        }

        public int hashCode() {
            return this.file.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.classifier, this.extension});
        }
    }
}

