# Copyright (c) 2018, ArrayFire
# All rights reserved.
#
# This file is distributed under 3-clause BSD license.
# The complete license agreement can be obtained at:
# http://arrayfire.com/licenses/BSD-3-Clause

# Forge
# -----
#
# This is the cmake configuration file for Forge library. It provides
# the following imported targets.
#
# ``Forge::forge`` - the target for Forge
#
# This target can be used to link with your application using the
# ``target_link_library`` command. Here is an example of how to use these
# targets in your application:
#
#   add_executable(mybinary source.cpp)
#   target_link_library(mybinary PRIVATE Forge::forge)
#
# This example creates a mybinary executable from the source.cpp file and links
# against the Forge library. Note you do *not* need to set the include
# directories as they are automatically included with the target.
#
# This is the recommended way of linking against Forge
#
#
# Legacy Variables
# ----------------
#
# Defines the following variables:
# Forge_INCLUDE_DIRS  - Path to Forge include directory.
# Forge_LIBRARIES     - Path to Forge libraries used in link commands.
# Forge_FOUND         - True if Forge backend has been found.
#
# You may provide a hint to where Forge's root directory may be located
# by setting Forge_DIR. You do not need to set this if you installed
# Forge using the official installers or the package manager(please submit
# a bug report if any issues). If CMake is unable to locate Forge then
# set the Forge_DIR to the directory of this file.
#
# If you are trying to link against a source build then this should be set to
# the build directory.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ForgeConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(Forge_INCLUDE_DIRS ${PACKAGE_PREFIX_DIR}/include)

set(Forge_FOUND OFF)

if (NOT TARGET Forge::forge AND
        NOT TARGET forge AND
        EXISTS ${PACKAGE_PREFIX_DIR}/share/Forge/cmake/ForgeTargets.cmake)
    include(${PACKAGE_PREFIX_DIR}/share/Forge/cmake/ForgeTargets.cmake)
endif ()

if (TARGET Forge::forge)
    get_property(config TARGET Forge::forge PROPERTY IMPORTED_CONFIGURATIONS)
    if(NOT config)
      set(config "NOCONFIG")
    endif()
    get_property(loc TARGET Forge::forge PROPERTY IMPORTED_LOCATION_${config})
endif ()

if ((TARGET Forge::forge AND EXISTS ${loc})
    OR
    TARGET forge)
    set(Forge_FOUND ON)
    if (TARGET forge AND NOT TARGET Forge::forge)
        add_library(Forge::forge ALIAS forge)
    endif ()
    set(Forge_LIBRARIES Forge::forge)
else ()
    set(Forge_FOUND OFF)
endif ()
