/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.ui.IActionFilter;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class FacetedProjectActionFilter
implements IActionFilter {
    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals("facet")) {
            IProject project = (IProject)target;
            IFacetedProject fproj = null;
            if (project.isAccessible()) {
                try {
                    fproj = ProjectFacetsManager.create((IProject)project);
                }
                catch (CoreException e1) {
                    Logger.getLogger().logError((Throwable)e1);
                }
            }
            if (fproj != null) {
                String vexprstr;
                String fid;
                int colon = value.indexOf(58);
                if (colon == -1 || colon == value.length() - 1) {
                    fid = value;
                    vexprstr = null;
                } else {
                    fid = value.substring(0, colon);
                    vexprstr = value.substring(colon + 1);
                }
                if (!ProjectFacetsManager.isProjectFacetDefined((String)fid)) {
                    return false;
                }
                IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)fid);
                if (!fproj.hasProjectFacet(f)) {
                    return false;
                }
                if (vexprstr == null) {
                    return true;
                }
                IProjectFacetVersion fv = fproj.getInstalledVersion(f);
                try {
                    if (f.getVersions(vexprstr).contains(fv)) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
                return false;
            }
            return false;
        }
        return true;
    }
}

