/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.io.OutputStream;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMCallbackServer;
import org.eclipse.jem.internal.proxy.common.IVMServer;
import org.eclipse.jem.internal.proxy.ide.IDECallbackRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;

public class IDEVMServer
implements IVMCallbackServer {
    IDECallbackRegistry fCallbackRegistry;
    IDEStandardBeanProxyFactory fBeanProxyFactory;

    IDEVMServer(IDECallbackRegistry aCallbackRegistry) {
        this.fCallbackRegistry = aCallbackRegistry;
        this.fBeanProxyFactory = (IDEStandardBeanProxyFactory)this.fCallbackRegistry.fProxyFactoryRegistry.getBeanProxyFactory();
    }

    public Object doCallback(ICallbackRunnable aRunnable) {
        try {
            return aRunnable.run(new ICallbackHandler(){

                public Object callbackWithParms(int callbackID, int msgID, Object[] parms) {
                    Object[] proxyParms = null;
                    if (parms != null) {
                        proxyParms = new Object[parms.length];
                        int i = 0;
                        while (i < parms.length) {
                            Object p = parms[i];
                            proxyParms[i] = this.createNextParm(p);
                            ++i;
                        }
                    }
                    return IDEVMServer.this.fCallbackRegistry.vmCallback(callbackID, msgID, proxyParms);
                }

                private Object createNextParm(Object p) {
                    if (!(p instanceof ICallbackHandler.TransmitableArray)) {
                        return IDEVMServer.this.fBeanProxyFactory.createIDEBeanProxyWith(p);
                    }
                    Object[] array = ((ICallbackHandler.TransmitableArray)p).getArray();
                    Object[] parm = new Object[array.length];
                    int i = 0;
                    while (i < array.length) {
                        parm[i] = this.createNextParm(array[i]);
                        ++i;
                    }
                    return parm;
                }

                public Object callbackAsConstants(int callbackID, int msgID, Object parm) throws CommandException {
                    return IDEVMServer.this.fCallbackRegistry.vmCallback(callbackID, msgID, parm);
                }
            });
        }
        catch (CommandException commandException) {
            return null;
        }
    }

    public OutputStream requestStream(int callbackID, int msgID) throws CommandException {
        return this.fCallbackRegistry.requestStream(callbackID, msgID);
    }

    public IVMServer getIVMServer() {
        return this.fCallbackRegistry.fProxyFactoryRegistry;
    }
}

