/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.efs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.efs.ChromiumScriptFileStore;

public class ChromiumScriptFileSystem
extends FileSystem {
    private static final String CHROMIUMDEBUG_SCHEME = "chromiumdebug";

    public IFileStore getStore(URI uri) {
        return new ChromiumScriptFileStore(this, ChromiumScriptFileSystem.toPath(uri));
    }

    public IFileStore getStore(IPath path) {
        return this.getStore(ChromiumScriptFileSystem.toUri(path));
    }

    public static URI getFileStoreUri(IPath path) {
        try {
            return new URI(CHROMIUMDEBUG_SCHEME, null, path.toPortableString(), null);
        }
        catch (URISyntaxException e) {
            ChromiumDebugPlugin.log(e);
            return null;
        }
    }

    public static boolean isChromiumDebugURI(URI uri) {
        return CHROMIUMDEBUG_SCHEME.equals(uri.getScheme());
    }

    static IPath toPath(URI uri) {
        return Path.fromPortableString((String)uri.getPath()).setDevice(null);
    }

    static URI toUri(IPath path) {
        try {
            return new URI(CHROMIUMDEBUG_SCHEME, null, path.toPortableString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

