/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repositoryv2;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.repository.io.FileOp;
import com.android.sdklib.internal.repository.CanceledByUserException;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.repositoryv2.LegacyTaskMonitor;
import com.android.utils.Pair;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class LegacyDownloader
implements Downloader {
    private DownloadCache mDownloadCache;
    private FileOp mFileOp;

    public LegacyDownloader(FileOp fop) {
        this.mDownloadCache = new DownloadCache(fop, DownloadCache.Strategy.FRESH_CACHE);
        this.mFileOp = fop;
    }

    public InputStream downloadAndStream(URL url, SettingsController controller, ProgressIndicator indicator) throws IOException {
        try {
            return this.mDownloadCache.openCachedUrl(url.toString(), new LegacyTaskMonitor(indicator));
        }
        catch (CanceledByUserException e) {
            indicator.logInfo("The download was cancelled.");
            return null;
        }
    }

    public File downloadFully(URL url, SettingsController settings, ProgressIndicator indicator) throws IOException {
        File result = File.createTempFile("LegacyDownloader", Long.toString(System.currentTimeMillis()));
        OutputStream out = this.mFileOp.newFileOutputStream(result);
        try {
            Pair<InputStream, Integer> downloadedResult = this.mDownloadCache.openDirectUrl(url.toString(), new LegacyTaskMonitor(indicator));
            if ((Integer)downloadedResult.getSecond() == 200) {
                ByteStreams.copy((InputStream)((InputStream)downloadedResult.getFirst()), (OutputStream)out);
                out.close();
                return result;
            }
        }
        catch (CanceledByUserException e) {
            indicator.logInfo("The download was cancelled.");
        }
        return null;
    }
}

