Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var SnippetsAvailable = (function () {
  function SnippetsAvailable(snippets) {
    var _this = this;

    _classCallCheck(this, SnippetsAvailable);

    this.panel = null;
    this.snippets = snippets;
    this.selectListView = new _atomSelectList2['default']({
      items: [],
      filterKeyForItem: function filterKeyForItem(snippet) {
        return snippet.searchText;
      },
      elementForItem: function elementForItem(snippet) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = snippet.prefix;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = snippet.name;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(snippet) {
        for (var cursor of _this.editor.getCursors()) {
          _this.snippets.insert(snippet.bodyText, _this.editor, cursor);
        }
        _this.cancel();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.cancel();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('available-snippets');
    this.element = this.selectListView.element;
  }

  _createClass(SnippetsAvailable, [{
    key: 'toggle',
    value: _asyncToGenerator(function* (editor) {
      this.editor = editor;
      if (this.panel != null) {
        this.cancel();
      } else {
        this.selectListView.reset();
        yield this.populate();
        this.attach();
      }
    })
  }, {
    key: 'cancel',
    value: function cancel() {
      this.editor = null;

      if (this.panel != null) {
        this.panel.destroy();
        this.panel = null;
      }

      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'populate',
    value: function populate() {
      var snippets = Object.values(this.snippets.getSnippets(this.editor));
      for (var snippet of snippets) {
        snippet.searchText = _underscorePlus2['default'].compact([snippet.prefix, snippet.name]).join(' ');
      }
      return this.selectListView.update({ items: snippets });
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel = atom.workspace.addModalPanel({ item: this });
      this.selectListView.focus();
    }
  }]);

  return SnippetsAvailable;
})();

exports['default'] = SnippetsAvailable;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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