Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var REBUILDING = 'rebuilding';
var REBUILD_FAILED = 'rebuild-failed';
var REBUILD_SUCCEEDED = 'rebuild-succeeded';

var IncompatiblePackagesComponent = (function () {
  function IncompatiblePackagesComponent(packageManager) {
    var _this = this;

    _classCallCheck(this, IncompatiblePackagesComponent);

    this.rebuildStatuses = new Map();
    this.rebuildFailureOutputs = new Map();
    this.rebuildInProgress = false;
    this.rebuiltPackageCount = 0;
    this.packageManager = packageManager;
    this.loaded = false;
    _etch2['default'].initialize(this);

    if (this.packageManager.getActivePackages().length > 0) {
      this.populateIncompatiblePackages();
    } else {
      global.setImmediate(this.populateIncompatiblePackages.bind(this));
    }

    this.element.addEventListener('click', function (event) {
      if (event.target === _this.refs.rebuildButton) {
        _this.rebuildIncompatiblePackages();
      } else if (event.target === _this.refs.reloadButton) {
        atom.reload();
      } else if (event.target.classList.contains('view-settings')) {
        atom.workspace.open('atom://config/packages/' + event.target['package'].name);
      }
    });
  }

  _createClass(IncompatiblePackagesComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      if (!this.loaded) {
        return _etch2['default'].dom(
          'div',
          { className: 'incompatible-packages padded' },
          'Loading...'
        );
      }

      return _etch2['default'].dom(
        'div',
        {
          className: 'incompatible-packages padded native-key-bindings',
          tabIndex: '-1'
        },
        this.renderHeading(),
        this.renderIncompatiblePackageList()
      );
    }
  }, {
    key: 'renderHeading',
    value: function renderHeading() {
      if (this.incompatiblePackages.length > 0) {
        if (this.rebuiltPackageCount > 0) {
          var alertClass = this.rebuiltPackageCount === this.incompatiblePackages.length ? 'alert-success icon-check' : 'alert-warning icon-bug';

          return _etch2['default'].dom(
            'div',
            { className: 'alert icon ' + alertClass },
            this.rebuiltPackageCount,
            ' of ',
            this.incompatiblePackages.length,
            ' ',
            'packages were rebuilt successfully. Reload Atom to activate them.',
            _etch2['default'].dom(
              'button',
              { ref: 'reloadButton', className: 'btn pull-right' },
              'Reload Atom'
            )
          );
        } else {
          return _etch2['default'].dom(
            'div',
            { className: 'alert alert-danger icon icon-bug' },
            'Some installed packages could not be loaded because they contain native modules that were compiled for an earlier version of Atom.',
            _etch2['default'].dom(
              'button',
              {
                ref: 'rebuildButton',
                className: 'btn pull-right',
                disabled: this.rebuildInProgress
              },
              'Rebuild Packages'
            )
          );
        }
      } else {
        return _etch2['default'].dom(
          'div',
          { className: 'alert alert-success icon icon-check' },
          'None of your packages contain incompatible native modules.'
        );
      }
    }
  }, {
    key: 'renderIncompatiblePackageList',
    value: function renderIncompatiblePackageList() {
      return _etch2['default'].dom(
        'div',
        null,
        this.incompatiblePackages.map(this.renderIncompatiblePackage.bind(this))
      );
    }
  }, {
    key: 'renderIncompatiblePackage',
    value: function renderIncompatiblePackage(pack) {
      var rebuildStatus = this.rebuildStatuses.get(pack);

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-package' },
        this.renderRebuildStatusIndicator(rebuildStatus),
        _etch2['default'].dom(
          'button',
          {
            className: 'btn view-settings icon icon-gear pull-right',
            'package': pack
          },
          'Package Settings'
        ),
        _etch2['default'].dom(
          'h4',
          { className: 'heading' },
          pack.name,
          ' ',
          pack.metadata.version
        ),
        rebuildStatus ? this.renderRebuildOutput(pack) : this.renderIncompatibleModules(pack)
      );
    }
  }, {
    key: 'renderRebuildStatusIndicator',
    value: function renderRebuildStatusIndicator(rebuildStatus) {
      if (rebuildStatus === REBUILDING) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-info pull-right icon icon-gear' },
          'Rebuilding'
        );
      } else if (rebuildStatus === REBUILD_SUCCEEDED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-success pull-right icon icon-check' },
          'Rebuild Succeeded'
        );
      } else if (rebuildStatus === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-error pull-right icon icon-x' },
          'Rebuild Failed'
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderRebuildOutput',
    value: function renderRebuildOutput(pack) {
      if (this.rebuildStatuses.get(pack) === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'pre',
          null,
          this.rebuildFailureOutputs.get(pack)
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIncompatibleModules',
    value: function renderIncompatibleModules(pack) {
      return _etch2['default'].dom(
        'ul',
        null,
        pack.incompatibleModules.map(function (nativeModule) {
          return _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom(
              'div',
              { className: 'icon icon-file-binary' },
              nativeModule.name,
              '@',
              nativeModule.version || 'unknown',
              ' –',
              ' ',
              _etch2['default'].dom(
                'span',
                { className: 'text-warning' },
                nativeModule.error
              )
            )
          );
        })
      );
    }
  }, {
    key: 'populateIncompatiblePackages',
    value: function populateIncompatiblePackages() {
      this.incompatiblePackages = this.packageManager.getLoadedPackages().filter(function (pack) {
        return !pack.isCompatible();
      });

      for (var pack of this.incompatiblePackages) {
        var buildFailureOutput = pack.getBuildFailureOutput();
        if (buildFailureOutput) {
          this.setPackageStatus(pack, REBUILD_FAILED);
          this.setRebuildFailureOutput(pack, buildFailureOutput);
        }
      }

      this.loaded = true;
      _etch2['default'].update(this);
    }
  }, {
    key: 'rebuildIncompatiblePackages',
    value: _asyncToGenerator(function* () {
      this.rebuildInProgress = true;
      var rebuiltPackageCount = 0;
      for (var pack of this.incompatiblePackages) {
        this.setPackageStatus(pack, REBUILDING);

        var _ref = yield pack.rebuild();

        var code = _ref.code;
        var stderr = _ref.stderr;

        if (code === 0) {
          this.setPackageStatus(pack, REBUILD_SUCCEEDED);
          rebuiltPackageCount++;
        } else {
          this.setRebuildFailureOutput(pack, stderr);
          this.setPackageStatus(pack, REBUILD_FAILED);
        }
      }
      this.rebuildInProgress = false;
      this.rebuiltPackageCount = rebuiltPackageCount;
      _etch2['default'].update(this);
    })
  }, {
    key: 'setPackageStatus',
    value: function setPackageStatus(pack, status) {
      this.rebuildStatuses.set(pack, status);
      _etch2['default'].update(this);
    }
  }, {
    key: 'setRebuildFailureOutput',
    value: function setRebuildFailureOutput(pack, output) {
      this.rebuildFailureOutputs.set(pack, output);
      _etch2['default'].update(this);
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Incompatible Packages';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return _viewUri2['default'];
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'package';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return { deserializer: 'IncompatiblePackagesComponent' };
    }
  }]);

  return IncompatiblePackagesComponent;
})();

exports['default'] = IncompatiblePackagesComponent;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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