"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareGithubDotcomMarkdown = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _issueishLink = require("./issueish-link");

var _userMentionTooltipItem = _interopRequireDefault(require("../items/user-mention-tooltip-item"));

var _issueishTooltipItem = _interopRequireDefault(require("../items/issueish-tooltip-item"));

var _relayEnvironment = _interopRequireDefault(require("./relay-environment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareGithubDotcomMarkdown extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handleClick", event => {
      if (event.target.dataset.url) {
        return this.props.handleClickEvent(event, event.target.dataset.url);
      } else {
        return null;
      }
    });

    _defineProperty(this, "openLinkInNewTab", event => {
      return this.props.openIssueishLinkInNewTab(event.target.dataset.url);
    });

    _defineProperty(this, "openLinkInThisTab", event => {
      const {
        repoOwner,
        repoName,
        issueishNumber
      } = (0, _issueishLink.getDataFromGithubUrl)(event.target.dataset.url);
      this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
    });

    _defineProperty(this, "openLinkInBrowser", event => {
      return this.props.openLinkInBrowser(event.target.getAttribute('href'));
    });
  }

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom["default"].findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.setupTooltipHandlers();
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem["default"](node.textContent, this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        "class": 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem["default"](node.getAttribute('href'), this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        "class": 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    return _react["default"].createElement("div", {
      className: `github-DotComMarkdownHtml native-key-bindings ${this.props.className}`,
      tabIndex: "-1",
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: {
        __html: this.props.html
      }
    });
  }

}

exports.BareGithubDotcomMarkdown = BareGithubDotcomMarkdown;

_defineProperty(BareGithubDotcomMarkdown, "propTypes", {
  relayEnvironment: _propTypes["default"].object.isRequired,
  className: _propTypes["default"].string,
  html: _propTypes["default"].string.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  handleClickEvent: _propTypes["default"].func,
  openIssueishLinkInNewTab: _propTypes["default"].func,
  openLinkInBrowser: _propTypes["default"].func
});

_defineProperty(BareGithubDotcomMarkdown, "defaultProps", {
  className: '',
  handleClickEvent: _issueishLink.handleClickEvent,
  openIssueishLinkInNewTab: _issueishLink.openIssueishLinkInNewTab,
  openLinkInBrowser: _issueishLink.openLinkInBrowser
});

class GithubDotcomMarkdown extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      lastMarkdown: null,
      html: null
    });
  }

  static getDerivedStateFromProps(props, state) {
    if (props.html) {
      return {
        html: props.html
      };
    }

    if (props.markdown && props.markdown !== state.lastMarkdown) {
      return {
        html: (0, _helpers.renderMarkdown)(props.markdown),
        lastMarkdown: props.markdown
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_relayEnvironment["default"].Consumer, null, relayEnvironment => _react["default"].createElement(BareGithubDotcomMarkdown, _extends({
      relayEnvironment: relayEnvironment
    }, this.props, {
      html: this.state.html
    })));
  }

}

exports["default"] = GithubDotcomMarkdown;

_defineProperty(GithubDotcomMarkdown, "propTypes", {
  markdown: _propTypes["default"].string,
  html: _propTypes["default"].string
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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