"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/removeReactionMutation.graphql");

  if (node.hash && node.hash !== "f20b76a0ff63579992f4631894495523") {
    console.error("The definition of 'removeReactionMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/removeReactionMutation.graphql");
};

var _default = (environment, subjectId, content) => {
  const variables = {
    input: {
      content,
      subjectId
    }
  };

  function optimisticUpdater(store) {
    const subject = store.get(subjectId);
    const reactionGroups = subject.getLinkedRecords('reactionGroups') || [];
    const reactionGroup = reactionGroups.find(group => group.getValue('content') === content);

    if (!reactionGroup) {
      return;
    }

    reactionGroup.setValue(false, 'viewerHasReacted');
    const conn = reactionGroup.getLinkedRecord('users');
    conn.setValue(conn.getValue('totalCount') - 1, 'totalCount');
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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