"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _reactRelay = require("react-relay");

var _userMentionTooltipContainer = _interopRequireDefault(require("../containers/user-mention-tooltip-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

class UserMentionTooltipItem {
  constructor(username, relayEnvironment) {
    this.username = username.substr(1);
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      this._element = document.createElement('div');

      const rootContainer = _react["default"].createElement(_reactRelay.QueryRenderer, {
        environment: this.relayEnvironment,
        query: _graphql || (_graphql = function () {
          const node = require("./__generated__/userMentionTooltipItemQuery.graphql");

          if (node.hash && node.hash !== "c0e8b6f6d3028f3f2679ce9e1486981e") {
            console.error("The definition of 'userMentionTooltipItemQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
          }

          return require("./__generated__/userMentionTooltipItemQuery.graphql");
        }),
        variables: {
          username: this.username
        },
        render: ({
          error,
          props,
          retry
        }) => {
          if (error) {
            return _react["default"].createElement("div", null, "Could not load information");
          } else if (props) {
            return _react["default"].createElement(_userMentionTooltipContainer["default"], props);
          } else {
            return _react["default"].createElement("div", {
              className: "github-Loader"
            }, _react["default"].createElement("span", {
              className: "github-Spinner"
            }));
          }
        }
      });

      this._component = _reactDom["default"].render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom["default"].unmountComponentAtNode(this._element);

      delete this._element;
    }
  }

}

exports["default"] = UserMentionTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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