(function() {
  var BufferSearch, CompositeDisposable, Disposable, FindOptions, FindView, History, HistoryCycler, ProjectFindView, ReporterProxy, ResultsModel, ResultsPaneView, SelectNext, TextBuffer, getIconServices, metricsReporter, ref, ref1;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, TextBuffer = ref.TextBuffer;

  SelectNext = require('./select-next');

  ref1 = require('./history'), History = ref1.History, HistoryCycler = ref1.HistoryCycler;

  FindOptions = require('./find-options');

  BufferSearch = require('./buffer-search');

  getIconServices = require('./get-icon-services');

  FindView = require('./find-view');

  ProjectFindView = require('./project-find-view');

  ResultsModel = require('./project/results-model');

  ResultsPaneView = require('./project/results-pane');

  ReporterProxy = require('./reporter-proxy');

  metricsReporter = new ReporterProxy();

  module.exports = {
    activate: function(arg) {
      var findHistory, findOptions, handleEditorCancel, pathsHistory, ref2, replaceHistory, selectNextObjectForEditorElement, showPanel, togglePanel;
      ref2 = arg != null ? arg : {}, findOptions = ref2.findOptions, findHistory = ref2.findHistory, replaceHistory = ref2.replaceHistory, pathsHistory = ref2.pathsHistory;
      if (atom.config.get('find-and-replace.openProjectFindResultsInRightPane')) {
        atom.config.set('find-and-replace.projectSearchResultsPaneSplitDirection', 'right');
      }
      atom.config.unset('find-and-replace.openProjectFindResultsInRightPane');
      atom.workspace.addOpener(function(filePath) {
        if (filePath === ResultsPaneView.URI) {
          return new ResultsPaneView();
        }
      });
      this.subscriptions = new CompositeDisposable;
      this.currentItemSub = new Disposable;
      this.findHistory = new History(findHistory);
      this.replaceHistory = new History(replaceHistory);
      this.pathsHistory = new History(pathsHistory);
      this.findOptions = new FindOptions(findOptions);
      this.findModel = new BufferSearch(this.findOptions);
      this.resultsModel = new ResultsModel(this.findOptions, metricsReporter);
      this.subscriptions.add(atom.workspace.getCenter().observeActivePaneItem((function(_this) {
        return function(paneItem) {
          _this.subscriptions["delete"](_this.currentItemSub);
          _this.currentItemSub.dispose();
          if (atom.workspace.isTextEditor(paneItem)) {
            return _this.findModel.setEditor(paneItem);
          } else if ((paneItem != null ? paneItem.observeEmbeddedTextEditor : void 0) != null) {
            _this.currentItemSub = paneItem.observeEmbeddedTextEditor(function(editor) {
              if (atom.workspace.getCenter().getActivePaneItem() === paneItem) {
                return _this.findModel.setEditor(editor);
              }
            });
            return _this.subscriptions.add(_this.currentItemSub);
          } else if ((paneItem != null ? paneItem.getEmbeddedTextEditor : void 0) != null) {
            return _this.findModel.setEditor(paneItem.getEmbeddedTextEditor());
          } else {
            return _this.findModel.setEditor(null);
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('.find-and-replace, .project-find', 'window:focus-next-pane', function() {
        return atom.views.getView(atom.workspace).focus();
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show-in-current-directory', (function(_this) {
        return function(arg1) {
          var target;
          target = arg1.target;
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          _this.projectFindView.focusFindElement();
          return _this.projectFindView.findInCurrentlySelectedDirectory(target);
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-find-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-replace-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show-replace', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusReplaceEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:clear-history', (function(_this) {
        return function() {
          _this.findHistory.clear();
          return _this.replaceHistory.clear();
        };
      })(this)));
      handleEditorCancel = (function(_this) {
        return function(arg1) {
          var isMiniEditor, ref3, ref4, target;
          target = arg1.target;
          isMiniEditor = target.tagName === 'ATOM-TEXT-EDITOR' && target.hasAttribute('mini');
          if (!isMiniEditor) {
            if ((ref3 = _this.findPanel) != null) {
              ref3.hide();
            }
            return (ref4 = _this.projectFindPanel) != null ? ref4.hide() : void 0;
          }
        };
      })(this);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': handleEditorCancel,
        'core:close': handleEditorCancel
      }));
      selectNextObjectForEditorElement = (function(_this) {
        return function(editorElement) {
          var editor, selectNext;
          if (_this.selectNextObjects == null) {
            _this.selectNextObjects = new WeakMap();
          }
          editor = editorElement.getModel();
          selectNext = _this.selectNextObjects.get(editor);
          if (selectNext == null) {
            selectNext = new SelectNext(editor);
            _this.selectNextObjects.set(editor, selectNext);
          }
          return selectNext;
        };
      })(this);
      showPanel = function(panelToShow, panelToHide, postShowAction) {
        panelToHide.hide();
        panelToShow.show();
        return typeof postShowAction === "function" ? postShowAction() : void 0;
      };
      togglePanel = function(panelToToggle, panelToHide, postToggleAction) {
        panelToHide.hide();
        if (panelToToggle.isVisible()) {
          return panelToToggle.hide();
        } else {
          panelToToggle.show();
          return typeof postToggleAction === "function" ? postToggleAction() : void 0;
        }
      };
      return this.subscriptions.add(atom.commands.add('.editor:not(.mini)', {
        'find-and-replace:select-next': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectNext();
        },
        'find-and-replace:select-all': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectAll();
        },
        'find-and-replace:select-undo': function(event) {
          return selectNextObjectForEditorElement(this).undoLastSelection();
        },
        'find-and-replace:select-skip': function(event) {
          return selectNextObjectForEditorElement(this).skipCurrentSelection();
        }
      }));
    },
    consumeMetricsReporter: function(service) {
      metricsReporter.setReporter(service);
      return new Disposable(function() {
        return metricsReporter.unsetReporter();
      });
    },
    consumeElementIcons: function(service) {
      getIconServices().setElementIcons(service);
      return new Disposable(function() {
        return getIconServices().resetElementIcons();
      });
    },
    consumeFileIcons: function(service) {
      getIconServices().setFileIcons(service);
      return new Disposable(function() {
        return getIconServices().resetFileIcons();
      });
    },
    toggleAutocompletions: function(value) {
      var disposable, ref2;
      if (this.findView == null) {
        return;
      }
      if (value) {
        this.autocompleteSubscriptions = new CompositeDisposable;
        disposable = typeof this.autocompleteWatchEditor === "function" ? this.autocompleteWatchEditor(this.findView.findEditor, ['default']) : void 0;
        if (disposable != null) {
          return this.autocompleteSubscriptions.add(disposable);
        }
      } else {
        return (ref2 = this.autocompleteSubscriptions) != null ? ref2.dispose() : void 0;
      }
    },
    consumeAutocompleteWatchEditor: function(watchEditor) {
      this.autocompleteWatchEditor = watchEditor;
      atom.config.observe('find-and-replace.autocompleteSearches', (function(_this) {
        return function(value) {
          return _this.toggleAutocompletions(value);
        };
      })(this));
      return new Disposable((function(_this) {
        return function() {
          var ref2;
          if ((ref2 = _this.autocompleteSubscriptions) != null) {
            ref2.dispose();
          }
          return _this.autocompleteWatchEditor = null;
        };
      })(this));
    },
    provideService: function() {
      return {
        resultsMarkerLayerForTextEditor: this.findModel.resultsMarkerLayerForTextEditor.bind(this.findModel)
      };
    },
    createViews: function() {
      var findBuffer, findHistoryCycler, options, pathsBuffer, pathsHistoryCycler, replaceBuffer, replaceHistoryCycler;
      if (this.findView != null) {
        return;
      }
      findBuffer = new TextBuffer;
      replaceBuffer = new TextBuffer;
      pathsBuffer = new TextBuffer;
      findHistoryCycler = new HistoryCycler(findBuffer, this.findHistory);
      replaceHistoryCycler = new HistoryCycler(replaceBuffer, this.replaceHistory);
      pathsHistoryCycler = new HistoryCycler(pathsBuffer, this.pathsHistory);
      options = {
        findBuffer: findBuffer,
        replaceBuffer: replaceBuffer,
        pathsBuffer: pathsBuffer,
        findHistoryCycler: findHistoryCycler,
        replaceHistoryCycler: replaceHistoryCycler,
        pathsHistoryCycler: pathsHistoryCycler
      };
      this.findView = new FindView(this.findModel, options);
      this.projectFindView = new ProjectFindView(this.resultsModel, options);
      this.findPanel = atom.workspace.addBottomPanel({
        item: this.findView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.projectFindPanel = atom.workspace.addBottomPanel({
        item: this.projectFindView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.findView.setPanel(this.findPanel);
      this.projectFindView.setPanel(this.projectFindPanel);
      ResultsPaneView.model = this.resultsModel;
      return this.toggleAutocompletions(atom.config.get('find-and-replace.autocompleteSearches'));
    },
    deactivate: function() {
      var ref2, ref3, ref4, ref5, ref6, ref7, ref8;
      if ((ref2 = this.findPanel) != null) {
        ref2.destroy();
      }
      this.findPanel = null;
      if ((ref3 = this.findView) != null) {
        ref3.destroy();
      }
      this.findView = null;
      if ((ref4 = this.findModel) != null) {
        ref4.destroy();
      }
      this.findModel = null;
      if ((ref5 = this.projectFindPanel) != null) {
        ref5.destroy();
      }
      this.projectFindPanel = null;
      if ((ref6 = this.projectFindView) != null) {
        ref6.destroy();
      }
      this.projectFindView = null;
      ResultsPaneView.model = null;
      this.resultsModel = null;
      if ((ref7 = this.autocompleteSubscriptions) != null) {
        ref7.dispose();
      }
      this.autocompleteManagerService = null;
      if ((ref8 = this.subscriptions) != null) {
        ref8.dispose();
      }
      return this.subscriptions = null;
    },
    serialize: function() {
      return {
        findOptions: this.findOptions.serialize(),
        findHistory: this.findHistory.serialize(),
        replaceHistory: this.replaceHistory.serialize(),
        pathsHistory: this.pathsHistory.serialize()
      };
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
