"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs-extra");
var getLogger_1 = require("../logging/getLogger");
var SchemaUpdater_1 = require("./SchemaUpdater");
var ConfigurationPersistence = (function () {
    function ConfigurationPersistence() {
        this.configFile = SchemaUpdater_1.SchemaUpdater.updateToVersion1();
        this.logger = getLogger_1.getLogger('ConfigurationPersistence');
        if (typeof global._ConfigurationPersistence === 'undefined') {
            global._ConfigurationPersistence = this.readFromFile();
        }
        this.logger.log('Init ConfigurationPersistence');
    }
    ConfigurationPersistence.prototype.delete = function (name) {
        this.logger.log("Deleting \"" + name + "\"");
        delete global._ConfigurationPersistence[name];
        return true;
    };
    ConfigurationPersistence.prototype.save = function (name, value) {
        this.logger.log("Saving \"" + name + "\" with value:", value);
        global._ConfigurationPersistence[name] = value;
        return true;
    };
    ConfigurationPersistence.prototype.restore = function (name, defaultValue) {
        this.logger.log("Restoring \"" + name + "\"");
        var value = global._ConfigurationPersistence[name];
        return typeof value !== 'undefined' ? value : defaultValue;
    };
    ConfigurationPersistence.prototype.persistToFile = function () {
        this.logger.log('Saving configuration to persistent storage:', global._ConfigurationPersistence);
        try {
            return fs.outputJsonSync(this.configFile, global._ConfigurationPersistence, { spaces: 2 });
        }
        catch (error) {
            this.logger.log('An error occurred while persisting the configuration', error);
        }
    };
    ConfigurationPersistence.prototype.readFromFile = function () {
        this.logger.log("Reading config file \"" + this.configFile + "\"...");
        try {
            return fs.readJSONSync(this.configFile);
        }
        catch (error) {
            var schemataKeys = Object.keys(SchemaUpdater_1.SchemaUpdater.SCHEMATA);
            return SchemaUpdater_1.SchemaUpdater.SCHEMATA[schemataKeys[schemataKeys.length - 1]];
        }
    };
    return ConfigurationPersistence;
}());
exports.settings = new ConfigurationPersistence();
//# sourceMappingURL=ConfigurationPersistence.js.map