"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var url_1 = require("url");
var getLogger_1 = require("../logging/getLogger");
var EnvironmentUtil_1 = require("../runtime/EnvironmentUtil");
var config_1 = require("../settings/config");
var WindowManager_1 = require("../window/WindowManager");
var eventType_1 = require("./eventType");
var logger = getLogger_1.getLogger(__filename);
var CORE_PROTOCOL_PREFIX = config_1.config.customProtocolName + "://";
var CORE_PROTOCOL_POSITION = 1;
var CORE_PROTOCOL_MAX_LENGTH = 1024;
var ProtocolCommand;
(function (ProtocolCommand) {
    ProtocolCommand["START_SSO_FLOW"] = "start-sso";
})(ProtocolCommand || (ProtocolCommand = {}));
var CustomProtocolHandler = (function () {
    function CustomProtocolHandler() {
        this.hashLocation = '';
        this.windowManager = WindowManager_1.WindowManager;
    }
    CustomProtocolHandler.prototype.dispatchDeepLink = function (url) {
        return __awaiter(this, void 0, void 0, function () {
            var route;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (typeof url === 'undefined' || !url.startsWith(CORE_PROTOCOL_PREFIX) || url.length > CORE_PROTOCOL_MAX_LENGTH) {
                            return [2];
                        }
                        route = new url_1.URL(url);
                        if (!(route.host === ProtocolCommand.START_SSO_FLOW)) return [3, 2];
                        return [4, this.handleSSOLogin(route)];
                    case 1:
                        _a.sent();
                        return [3, 3];
                    case 2:
                        this.forwardHashLocation(route);
                        _a.label = 3;
                    case 3: return [2];
                }
            });
        });
    };
    CustomProtocolHandler.prototype.forwardHashLocation = function (route) {
        var location = route.href.substr(CORE_PROTOCOL_PREFIX.length);
        this.hashLocation = "/" + location;
        this.windowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH, this.hashLocation);
    };
    CustomProtocolHandler.prototype.handleSSOLogin = function (route) {
        return __awaiter(this, void 0, void 0, function () {
            var code, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(typeof route.pathname === 'string')) return [3, 4];
                        logger.log('Starting SSO flow...');
                        code = route.pathname.trim().substr(1);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4, this.windowManager.sendActionAndFocusWindow(eventType_1.EVENT_TYPE.ACCOUNT.SSO_LOGIN, code)];
                    case 2:
                        _a.sent();
                        return [3, 4];
                    case 3:
                        error_1 = _a.sent();
                        logger.error("Cannot start SSO flow: " + error_1.message, error_1);
                        return [3, 4];
                    case 4: return [2];
                }
            });
        });
    };
    CustomProtocolHandler.prototype.registerCoreProtocol = function () {
        var _this = this;
        if (!electron_1.app.isDefaultProtocolClient(config_1.config.customProtocolName)) {
            electron_1.app.setAsDefaultProtocolClient(config_1.config.customProtocolName);
        }
        if (EnvironmentUtil_1.platform.IS_MAC_OS) {
            electron_1.app.on('open-url', function (event, url) { return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            event.preventDefault();
                            return [4, this.dispatchDeepLink(url)];
                        case 1:
                            _a.sent();
                            return [2];
                    }
                });
            }); });
        }
        else {
            electron_1.app.once('ready', function () { return __awaiter(_this, void 0, void 0, function () {
                var url;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            url = process.argv[CORE_PROTOCOL_POSITION];
                            return [4, this.dispatchDeepLink(url)];
                        case 1:
                            _a.sent();
                            return [2];
                    }
                });
            }); });
            electron_1.app.on('second-instance', function (event, argv) { return __awaiter(_this, void 0, void 0, function () {
                var url;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            url = argv[CORE_PROTOCOL_POSITION];
                            return [4, this.dispatchDeepLink(url)];
                        case 1:
                            _a.sent();
                            return [2];
                    }
                });
            }); });
        }
    };
    return CustomProtocolHandler;
}());
exports.CustomProtocolHandler = CustomProtocolHandler;
//# sourceMappingURL=CoreProtocol.js.map