/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessor;", "Lcom/intellij/openapi/Disposable;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "listeners", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "kotlin.jvm.PlatformType", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "queue", "Lcom/intellij/util/concurrency/QueueProcessor;", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "addListener", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "dispose", "processEvents", "events", "Companion", "ListenerAndDisposable", "intellij.platform.vcs.impl"})
public final class AsyncVfsEventsPostProcessorImpl
implements AsyncVfsEventsPostProcessor,
Disposable {
    private final Logger LOG;
    private final QueueProcessor<List<VFileEvent>> queue;
    private final MessageBus messageBus;
    private final ConcurrentList<ListenerAndDisposable> listeners;
    public static final Companion Companion = new Companion(null);

    public void addListener(@NotNull AsyncVfsEventsListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        ListenerAndDisposable element = new ListenerAndDisposable(listener, disposable);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(this, element){
            final /* synthetic */ AsyncVfsEventsPostProcessorImpl this$0;
            final /* synthetic */ ListenerAndDisposable $element;

            public final void dispose() {
                AsyncVfsEventsPostProcessorImpl.access$getListeners$p(this.this$0).remove((Object)this.$element);
            }
            {
                this.this$0 = asyncVfsEventsPostProcessorImpl;
                this.$element = listenerAndDisposable;
            }
        });
        this.listeners.add((Object)element);
    }

    public void dispose() {
        this.queue.clear();
        this.listeners.clear();
    }

    private final void processEvents(List<? extends VFileEvent> events) {
        for (ListenerAndDisposable listenerAndDisposable : this.listeners) {
            AsyncVfsEventsListener listener = listenerAndDisposable.component1();
            Disposable parentDisposable = listenerAndDisposable.component2();
            try {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)parentDisposable, (Runnable)new Runnable(listener, events){
                    final /* synthetic */ AsyncVfsEventsListener $listener;
                    final /* synthetic */ List $events;

                    public final void run() {
                        this.$listener.filesChanged(this.$events);
                    }
                    {
                        this.$listener = asyncVfsEventsListener;
                        this.$events = list;
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                this.LOG.error(e);
            }
        }
    }

    public AsyncVfsEventsPostProcessorImpl() {
        Logger logger;
        AsyncVfsEventsPostProcessorImpl asyncVfsEventsPostProcessorImpl = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(AsyncVfsEventsPostProcessorImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        asyncVfsEventsPostProcessorImpl.LOG = logger = logger2;
        this.queue = new QueueProcessor(new Consumer<T>(this){
            final /* synthetic */ AsyncVfsEventsPostProcessorImpl this$0;

            public final void consume(List<? extends VFileEvent> events) {
                List<? extends VFileEvent> list = events;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"events");
                AsyncVfsEventsPostProcessorImpl.access$processEvents(this.this$0, list);
            }
            {
                this.this$0 = asyncVfsEventsPostProcessorImpl;
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBus messageBus = application.getMessageBus();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"ApplicationManager.getApplication().messageBus");
        this.messageBus = messageBus;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentList, (String)"ContainerUtil.createConc\u2026<ListenerAndDisposable>()");
        this.listeners = concurrentList;
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                queue.add(events);
            }
        });
    }

    public static final /* synthetic */ ConcurrentList access$getListeners$p(AsyncVfsEventsPostProcessorImpl $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$processEvents(AsyncVfsEventsPostProcessorImpl $this, List events) {
        $this.processEvents(events);
    }

    @JvmStatic
    public static final void waitEventsProcessed() {
        Companion.waitEventsProcessed();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vfs/AsyncVfsEventsListener;Lcom/intellij/openapi/Disposable;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getListener", "()Lcom/intellij/vfs/AsyncVfsEventsListener;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class ListenerAndDisposable {
        @NotNull
        private final AsyncVfsEventsListener listener;
        @NotNull
        private final Disposable disposable;

        @NotNull
        public final AsyncVfsEventsListener getListener() {
            return this.listener;
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        public ListenerAndDisposable(@NotNull AsyncVfsEventsListener listener, @NotNull Disposable disposable) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            this.listener = listener;
            this.disposable = disposable;
        }

        @NotNull
        public final AsyncVfsEventsListener component1() {
            return this.listener;
        }

        @NotNull
        public final Disposable component2() {
            return this.disposable;
        }

        @NotNull
        public final ListenerAndDisposable copy(@NotNull AsyncVfsEventsListener listener, @NotNull Disposable disposable) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            return new ListenerAndDisposable(listener, disposable);
        }

        public static /* synthetic */ ListenerAndDisposable copy$default(ListenerAndDisposable listenerAndDisposable, AsyncVfsEventsListener asyncVfsEventsListener, Disposable disposable, int n, Object object) {
            if ((n & 1) != 0) {
                asyncVfsEventsListener = listenerAndDisposable.listener;
            }
            if ((n & 2) != 0) {
                disposable = listenerAndDisposable.disposable;
            }
            return listenerAndDisposable.copy(asyncVfsEventsListener, disposable);
        }

        @NotNull
        public String toString() {
            return "ListenerAndDisposable(listener=" + this.listener + ", disposable=" + this.disposable + ")";
        }

        public int hashCode() {
            AsyncVfsEventsListener asyncVfsEventsListener = this.listener;
            Disposable disposable = this.disposable;
            return (asyncVfsEventsListener != null ? asyncVfsEventsListener.hashCode() : 0) * 31 + (disposable != null ? disposable.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListenerAndDisposable)) break block3;
                    ListenerAndDisposable listenerAndDisposable = (ListenerAndDisposable)object;
                    if (!Intrinsics.areEqual((Object)this.listener, (Object)listenerAndDisposable.listener) || !Intrinsics.areEqual((Object)this.disposable, (Object)listenerAndDisposable.disposable)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$Companion;", "", "()V", "waitEventsProcessed", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        public final void waitEventsProcessed() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            boolean bl = application.isUnitTestMode();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            AsyncVfsEventsPostProcessor asyncVfsEventsPostProcessor = AsyncVfsEventsPostProcessor.getInstance();
            if (asyncVfsEventsPostProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.vfs.AsyncVfsEventsPostProcessorImpl");
            }
            ((AsyncVfsEventsPostProcessorImpl)asyncVfsEventsPostProcessor).queue.waitFor();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

